/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.jpa.internal.JPAContextInitializer;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.test.idm.config.AbstractFeaturesSetConfigurationTestCase;
import org.picketlink.test.idm.relationship.CustomRelationship;

public class JPAIdentityStoreConfigurationTestCase
extends AbstractFeaturesSetConfigurationTestCase<JPAStoreConfigurationBuilder> {
    private EntityManagerFactory emf;
    private EntityManager entityManager;

    @Before
    public void onInit() {
        this.emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
        this.entityManager = this.emf.createEntityManager();
        this.entityManager.getTransaction().begin();
    }

    @After
    public void onDestroy() {
        this.entityManager.getTransaction().commit();
        this.entityManager.close();
        this.emf.close();
    }

    @Test
    public void failFeatureNotSupportedWhenEntityClassesNotProvided() {
        SecurityConfigurationException sce;
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        JPAStoreConfigurationBuilder jpaConfig = this.createMinimalConfiguration(builder);
        jpaConfig.relationshipClass(null);
        jpaConfig.relationshipIdentityClass(null);
        jpaConfig.relationshipAttributeClass(null);
        this.addContextInitializers(jpaConfig);
        IdentityManager identityManager = this.createIdentityManager(builder.build());
        SimpleUser user = new SimpleUser("someUser");
        identityManager.add((IdentityType)user);
        SimpleRole role = new SimpleRole("someRole");
        identityManager.add((IdentityType)role);
        SimpleGroup group = new SimpleGroup("someGroup");
        identityManager.add((IdentityType)group);
        try {
            identityManager.add((Relationship)new Grant((IdentityType)user, (Role)role));
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(Grant.class.getName()));
            }
            Assert.fail();
        }
        try {
            identityManager.add((Relationship)new GroupRole((IdentityType)user, (Group)group, (Role)role));
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(GroupRole.class.getName()));
            }
            Assert.fail();
        }
        try {
            identityManager.add((Relationship)new GroupMembership((Agent)user, (Group)group));
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(GroupMembership.class.getName()));
            }
            Assert.fail();
        }
        try {
            CustomRelationship customRelationship = new CustomRelationship();
            customRelationship.setIdentityTypeA((IdentityType)user);
            customRelationship.setIdentityTypeB((IdentityType)role);
            customRelationship.setIdentityTypeC((IdentityType)group);
            identityManager.add((Relationship)customRelationship);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(CustomRelationship.class.getName()));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedWhenCredentialClassesNotProvided() {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        JPAStoreConfigurationBuilder jpaConfig = this.createMinimalConfiguration(builder);
        jpaConfig.credentialClass(null);
        this.addContextInitializers(jpaConfig);
        IdentityManager identityManager = this.createIdentityManager(builder.build());
        SimpleUser user = new SimpleUser("someUser");
        identityManager.add((IdentityType)user);
        Password password = new Password("123");
        try {
            identityManager.updateCredential((Agent)user, (Object)password);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[credential.update]"));
        }
        builder = new IdentityConfigurationBuilder();
        jpaConfig = this.createMinimalConfiguration(builder);
        jpaConfig.credentialClass(CredentialObject.class);
        jpaConfig.credentialAttributeClass(null);
        this.addContextInitializers(jpaConfig);
        identityManager = this.createIdentityManager(builder.build());
        try {
            identityManager.updateCredential((Agent)user, (Object)password);
            Assert.fail();
        }
        catch (OperationNotSupportedException one) {
            Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.credential));
            Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.update));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failIdentityClassNotProvided() {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        JPAStoreConfigurationBuilder jpaConfig = this.createMinimalConfiguration(builder);
        jpaConfig.identityClass(null);
        this.addContextInitializers(jpaConfig);
        try {
            this.createIdentityManager(builder.build());
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("identityclass not set"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failPartitionClassNotProvided() {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        JPAStoreConfigurationBuilder jpaConfig = this.createMinimalConfiguration(builder);
        jpaConfig.identityClass(IdentityObject.class);
        jpaConfig.partitionClass(null);
        this.addContextInitializers(jpaConfig);
        try {
            this.createIdentityManager(builder.build());
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("partitionclass not set"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Override
    protected JPAStoreConfigurationBuilder createMinimalConfiguration(IdentityConfigurationBuilder builder) {
        JPAStoreConfigurationBuilder jpaConfig = builder.stores().jpa();
        jpaConfig.identityClass(IdentityObject.class);
        jpaConfig.partitionClass(PartitionObject.class);
        jpaConfig.relationshipClass(RelationshipObject.class);
        jpaConfig.relationshipIdentityClass(RelationshipIdentityObject.class);
        jpaConfig.relationshipAttributeClass(RelationshipObjectAttribute.class);
        jpaConfig.credentialClass(CredentialObject.class);
        jpaConfig.credentialAttributeClass(CredentialObjectAttribute.class);
        jpaConfig.supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.role, FeatureSet.FeatureGroup.group, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureGroup.credential});
        jpaConfig.supportRelationshipType(new Class[]{CustomRelationship.class});
        return jpaConfig;
    }

    @Override
    protected void addContextInitializers(JPAStoreConfigurationBuilder config) {
        config.addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return JPAIdentityStoreConfigurationTestCase.this.entityManager;
            }
        });
    }
}

