/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.test.idm.config.AbstractFeaturesSetConfigurationTestCase;
import org.picketlink.test.idm.relationship.CustomRelationship;
import org.picketlink.test.idm.suites.LDAPAbstractSuite;

public class LDAPIdentityStoreConfigurationTestCase
extends AbstractFeaturesSetConfigurationTestCase<LDAPStoreConfigurationBuilder> {
    private static LDAPAbstractSuite instance;

    @BeforeClass
    public static void onBeforeClass() {
        try {
            instance = new LDAPAbstractSuite(){

                @Override
                @Before
                public void setup() throws Exception {
                    super.setup();
                    this.importLDIF("ldap/users.ldif");
                }
            };
            instance.setup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void onDestroyClass() {
        try {
            instance.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Test
    public void failFeatureNotSupportedCustomRelationship() {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        LDAPStoreConfigurationBuilder storeConfig = this.createMinimalConfiguration(builder);
        IdentityManager identityManager = this.createIdentityManager(builder.build());
        SimpleUser user = new SimpleUser("someUser");
        identityManager.add((IdentityType)user);
        SimpleRole role = new SimpleRole("someRole");
        identityManager.add((IdentityType)role);
        CustomRelationship customRelationship = new CustomRelationship();
        customRelationship.setIdentityTypeA((IdentityType)user);
        customRelationship.setIdentityTypeB((IdentityType)role);
        try {
            identityManager.add((Relationship)customRelationship);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                SecurityConfigurationException sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(CustomRelationship.class.getName()));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Override
    protected LDAPStoreConfigurationBuilder createMinimalConfiguration(IdentityConfigurationBuilder builder) {
        LDAPStoreConfigurationBuilder storeConfig = (LDAPStoreConfigurationBuilder)builder.stores().ldap().baseDN(instance.getBaseDn()).bindDN(instance.getBindDn()).bindCredential(instance.getBindCredential()).url(instance.getConnectionUrl()).userDNSuffix(instance.getUserDnSuffix()).roleDNSuffix(instance.getRolesDnSuffix()).agentDNSuffix(instance.getAgentDnSuffix()).groupDNSuffix(instance.getGroupDnSuffix()).addGroupMapping("/QA Group", "ou=QA,dc=jboss,dc=org").supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.agent, FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.group, FeatureSet.FeatureGroup.role, FeatureSet.FeatureGroup.attribute, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureGroup.credential});
        return storeConfig;
    }
}

