/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.idm.jpa.internal.JPAContextInitializer;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.IdentityObjectAttribute;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.password.PasswordEncoder;
import org.picketlink.idm.password.internal.BCryptPasswordEncoder;
import org.picketlink.idm.password.internal.PBKDF2PasswordEncoder;
import org.picketlink.idm.password.internal.SHAPasswordEncoder;
import org.picketlink.idm.spi.ContextInitializer;

public class PasswordCredentialHandlerConfigurationTestCase {
    private EntityManagerFactory emf;
    private EntityManager entityManager;

    @Before
    public void onInit() {
        this.emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
        this.entityManager = this.emf.createEntityManager();
        this.entityManager.getTransaction().begin();
    }

    @After
    public void onDestroy() {
        this.entityManager.getTransaction().commit();
        this.entityManager.close();
        this.emf.close();
    }

    @Test
    public void testBCryptPasswordEncoder() throws Exception {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().setCredentialHandlerProperty("PASSWORD_ENCODER", (Object)new BCryptPasswordEncoder(4))).addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return PasswordCredentialHandlerConfigurationTestCase.this.entityManager;
            }
        })).addRealm(new String[]{"default"})).supportAllFeatures()).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class);
        IdentityManagerFactory identityManagerFactory = new IdentityManagerFactory(builder.build());
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        user = identityManager.getUser(user.getLoginName());
        Assert.assertNotNull((Object)user);
        Password password = new Password("123");
        identityManager.updateCredential((Agent)user, (Object)password);
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials(user.getLoginName(), password);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
    }

    @Test
    public void testPBKDF2PasswordEncoder() throws Exception {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().setCredentialHandlerProperty("PASSWORD_ENCODER", (Object)new PBKDF2PasswordEncoder("salty".getBytes(), 1000, 128))).addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return PasswordCredentialHandlerConfigurationTestCase.this.entityManager;
            }
        })).addRealm(new String[]{"default"})).supportAllFeatures()).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class);
        IdentityManagerFactory identityManagerFactory = new IdentityManagerFactory(builder.build());
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        user = identityManager.getUser(user.getLoginName());
        Assert.assertNotNull((Object)user);
        Password password = new Password("123");
        identityManager.updateCredential((Agent)user, (Object)password);
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials(user.getLoginName(), password);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
    }

    @Test
    public void testCustomSHAPasswordEncoder() throws Exception {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().setCredentialHandlerProperty("PASSWORD_ENCODER", (Object)new SHAPasswordEncoder(1){

            public String encode(String rawPassword) {
                Assert.assertEquals((long)1L, (long)this.getStrength());
                return super.encode(rawPassword);
            }

            public boolean verify(String rawPassword, String encodedPassword) {
                return super.verify(rawPassword, encodedPassword);
            }
        })).addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return PasswordCredentialHandlerConfigurationTestCase.this.entityManager;
            }
        })).addRealm(new String[]{"default"})).supportAllFeatures()).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class);
        IdentityManagerFactory identityManagerFactory = new IdentityManagerFactory(builder.build());
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        user = identityManager.getUser(user.getLoginName());
        Assert.assertNotNull((Object)user);
        Password password = new Password("123");
        identityManager.updateCredential((Agent)user, (Object)password);
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials(user.getLoginName(), password);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
    }

    @Test
    public void testCustomPasswordEncoder() throws Exception {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        final HashMap assertionCheck = new HashMap();
        ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().setCredentialHandlerProperty("PASSWORD_ENCODER", (Object)new PasswordEncoder(){

            public String encode(String rawPassword) {
                assertionCheck.put("WAS_INVOKED", "true");
                return rawPassword;
            }

            public boolean verify(String rawPassword, String encodedPassword) {
                return true;
            }
        })).addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return PasswordCredentialHandlerConfigurationTestCase.this.entityManager;
            }
        })).addRealm(new String[]{"default"})).supportAllFeatures()).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class);
        IdentityManagerFactory identityManagerFactory = new IdentityManagerFactory(builder.build());
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        user = identityManager.getUser(user.getLoginName());
        Assert.assertNotNull((Object)user);
        Password password = new Password("123");
        identityManager.updateCredential((Agent)user, (Object)password);
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials(user.getLoginName(), password);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
        Assert.assertEquals((Object)"true", assertionCheck.get("WAS_INVOKED"));
    }

    @Test(expected=IdentityManagementException.class)
    public void failInvalidEncodingAlgorithm() throws Exception {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        HashMap assertionCheck = new HashMap();
        ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().setCredentialHandlerProperty("PASSWORD_ENCODER", (Object)new SHAPasswordEncoder(999){

            public String encode(String rawPassword) {
                String encode = super.encode(rawPassword);
                Assert.fail();
                return encode;
            }
        })).addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return PasswordCredentialHandlerConfigurationTestCase.this.entityManager;
            }
        })).addRealm(new String[]{"default"})).supportAllFeatures()).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class);
        IdentityManagerFactory identityManagerFactory = new IdentityManagerFactory(builder.build());
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        user = identityManager.getUser(user.getLoginName());
        Assert.assertNotNull((Object)user);
        Password password = new Password("123");
        try {
            identityManager.updateCredential((Agent)user, (Object)password);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("PLIDM000072"));
            throw e;
        }
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials(user.getLoginName(), password);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
    }
}

