/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.FileStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.idm.jpa.internal.JPAContextInitializer;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.IdentityObjectAttribute;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.test.idm.suites.LDAPAbstractSuite;

public class ProgrammaticConfigurationTestCase {
    private EntityManagerFactory emf;
    private EntityManager entityManager;
    private LDAPAbstractSuite ldapServer;

    @Before
    public void onInit() throws Exception {
        this.emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
        this.entityManager = this.emf.createEntityManager();
        this.entityManager.getTransaction().begin();
        this.ldapServer = new LDAPAbstractSuite(){};
        this.ldapServer.setup();
        this.ldapServer.importLDIF("ldap/users.ldif");
    }

    @After
    public void onDestroy() throws Exception {
        this.entityManager.getTransaction().commit();
        this.entityManager.close();
        this.emf.close();
        this.ldapServer.tearDown();
    }

    @Test
    public void testFileIdentityStoreConfiguration() throws Exception {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((FileStoreConfigurationBuilder)((FileStoreConfigurationBuilder)((FileStoreConfigurationBuilder)builder.stores().file().preserveState(false).workingDirectory("/tmp/pl-idm").asyncWrite(true).asyncWriteThreadPool(10).addRealm(new String[]{"default"})).addRealm(new String[]{"Realm"})).addTier(new String[]{"Tier"})).supportAllFeatures();
        IdentityManagerFactory identityManagerFactory = new IdentityManagerFactory(builder.build());
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        junit.framework.Assert.assertNotNull((Object)identityManager.getUser(user.getLoginName()));
    }

    @Test
    public void testJPAIdentityStoreConfiguration() throws Exception {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return ProgrammaticConfigurationTestCase.this.entityManager;
            }
        })).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class).addRealm(new String[]{"default"})).addRealm(new String[]{"Realm"})).addTier(new String[]{"Tier"})).supportAllFeatures();
        IdentityManagerFactory identityManagerFactory = new IdentityManagerFactory(builder.build());
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        junit.framework.Assert.assertNotNull((Object)identityManager.getUser(user.getLoginName()));
    }

    @Test
    public void testLDAPIdentityStoreConfiguration() throws Exception {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((LDAPStoreConfigurationBuilder)builder.stores().ldap().baseDN(this.ldapServer.getBaseDn()).bindDN(this.ldapServer.getBindDn()).bindCredential(this.ldapServer.getBindCredential()).url(this.ldapServer.getConnectionUrl()).userDNSuffix(this.ldapServer.getUserDnSuffix()).roleDNSuffix(this.ldapServer.getRolesDnSuffix()).agentDNSuffix(this.ldapServer.getAgentDnSuffix()).groupDNSuffix(this.ldapServer.getGroupDnSuffix()).addRealm(new String[]{"default"})).supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.agent, FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.group, FeatureSet.FeatureGroup.role, FeatureSet.FeatureGroup.attribute, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureGroup.credential});
        IdentityManagerFactory identityManagerFactory = new IdentityManagerFactory(builder.build());
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        junit.framework.Assert.assertNotNull((Object)identityManager.getUser(user.getLoginName()));
    }

    @Test
    public void failDuplicatedFeatureConfiguration() throws Exception {
        IdentityConfigurationBuilder configuration = new IdentityConfigurationBuilder();
        configuration.stores().file().supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user});
        configuration.stores().jpa().identityClass(IdentityObject.class).partitionClass(PartitionObject.class).supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user});
        try {
            new IdentityManagerFactory(configuration.build());
            Assert.fail();
        }
        catch (SecurityConfigurationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("PLIDM000071"));
            if (!e.getMessage().contains("PLIDM000071")) {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

