/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import java.util.Calendar;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.TOTPCredential;
import org.picketlink.idm.credential.TOTPCredentials;
import org.picketlink.idm.credential.totp.TimeBasedOTP;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.idm.jpa.internal.JPAContextInitializer;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.IdentityObjectAttribute;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.spi.ContextInitializer;

public class TOTPCredentialHandlerConfigurationTestCase {
    private static final String USER_TOTP_SECRET = "my_secret";
    private static final String USER_PASSWORD = "passwd";
    private static final String USER_NAME = "user";
    private EntityManagerFactory emf;
    private EntityManager entityManager;

    @Before
    public void onInit() {
        this.emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
        this.entityManager = this.emf.createEntityManager();
        this.entityManager.getTransaction().begin();
    }

    @After
    public void onDestroy() {
        this.entityManager.getTransaction().commit();
        this.entityManager.close();
        this.emf.close();
    }

    @Test
    public void testNoDelayWindow() throws Exception {
        IdentityManager identityManager = this.createIdentityManager("DELAY_WINDOW", 0);
        TOTPCredentials credentials = new TOTPCredentials();
        credentials.setUsername(USER_NAME);
        credentials.setPassword(new Password(USER_PASSWORD));
        TimeBasedOTP totp = new TimeBasedOTP();
        String token = totp.generate(USER_TOTP_SECRET);
        credentials.setToken(token);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credentials.getStatus());
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -30);
        totp.setCalendar(calendar);
        token = totp.generate(USER_TOTP_SECRET);
        credentials.setToken(token);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)credentials.getStatus());
    }

    @Test
    public void testNumberDigits() throws Exception {
        int numberDigits = 8;
        IdentityManager identityManager = this.createIdentityManager("NUMBER_DIGITS", numberDigits);
        TOTPCredentials credentials = new TOTPCredentials();
        credentials.setUsername(USER_NAME);
        credentials.setPassword(new Password(USER_PASSWORD));
        TimeBasedOTP totp = new TimeBasedOTP("HmacSHA1", numberDigits, 30, 1);
        String token = totp.generate(USER_TOTP_SECRET);
        Assert.assertEquals((long)numberDigits, (long)token.length());
        credentials.setToken(token);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credentials.getStatus());
    }

    @Test
    public void testInterval() throws Exception {
        int timeIntervalInSeconds = 10;
        IdentityManager identityManager = this.createIdentityManager("INTERVAL_SECONDS", timeIntervalInSeconds);
        TOTPCredentials credentials = new TOTPCredentials();
        credentials.setUsername(USER_NAME);
        credentials.setPassword(new Password(USER_PASSWORD));
        TimeBasedOTP totp = new TimeBasedOTP("HmacSHA1", 6, timeIntervalInSeconds, 1);
        String token = totp.generate(USER_TOTP_SECRET);
        credentials.setToken(token);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credentials.getStatus());
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -timeIntervalInSeconds);
        totp.setCalendar(calendar);
        token = totp.generate(USER_TOTP_SECRET);
        credentials.setToken(token);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credentials.getStatus());
    }

    private IdentityManager createIdentityManager(String propertyKey, Object propertyValue) {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().setCredentialHandlerProperty(propertyKey, propertyValue)).addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return TOTPCredentialHandlerConfigurationTestCase.this.entityManager;
            }
        })).addRealm(new String[]{"default"})).supportAllFeatures()).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class);
        IdentityManagerFactory identityManagerFactory = new IdentityManagerFactory(builder.build());
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        this.createUser(identityManager);
        return identityManager;
    }

    private void createUser(IdentityManager identityManager) {
        SimpleUser user = new SimpleUser(USER_NAME);
        identityManager.add((IdentityType)user);
        user = identityManager.getUser(user.getLoginName());
        Assert.assertNotNull((Object)user);
        TOTPCredential credential = new TOTPCredential(USER_PASSWORD, USER_TOTP_SECRET);
        identityManager.updateCredential((Agent)user, (Object)credential);
    }
}

