/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.credential;

import java.util.Calendar;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.TOTPCredential;
import org.picketlink.idm.credential.TOTPCredentials;
import org.picketlink.idm.credential.totp.TimeBasedOTP;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class TOTPCredentialTestCase
extends AbstractIdentityManagerTestCase {
    public static final String DEFAULT_TOTP_SECRET = "my_secret";
    public static final String DEFAULT_PASSWORD = "passwd";

    @Test
    public void testSuccessfulValidation() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        TOTPCredential credential = new TOTPCredential(DEFAULT_PASSWORD, DEFAULT_TOTP_SECRET);
        identityManager.updateCredential((Agent)user, (Object)credential);
        TOTPCredentials credentials = new TOTPCredentials();
        credentials.setUsername(user.getLoginName());
        credentials.setPassword(new Password(DEFAULT_PASSWORD));
        TimeBasedOTP totp = new TimeBasedOTP();
        String token = totp.generate(DEFAULT_TOTP_SECRET);
        credentials.setToken(token);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credentials.getStatus());
        Assert.assertNotNull((Object)credentials.getValidatedAgent());
    }

    @Test
    public void testMultipleDevices() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        TOTPCredential defaultDevice = new TOTPCredential(DEFAULT_PASSWORD, DEFAULT_TOTP_SECRET);
        identityManager.updateCredential((Agent)user, (Object)defaultDevice);
        String iphoneSecret = "iphone_secret";
        TOTPCredential iphoneDevice = new TOTPCredential(DEFAULT_PASSWORD, iphoneSecret);
        String iphoneDeviceName = "My IPhone #SN-121212121";
        iphoneDevice.setDevice(iphoneDeviceName);
        identityManager.updateCredential((Agent)user, (Object)iphoneDevice);
        String androidSecret = "android_secret";
        TOTPCredential androidDevice = new TOTPCredential(DEFAULT_PASSWORD, androidSecret);
        String androidDeviceName = "My Android #SN-56757554";
        androidDevice.setDevice(androidDeviceName);
        identityManager.updateCredential((Agent)user, (Object)androidDevice);
        TOTPCredentials credentials = new TOTPCredentials();
        credentials.setUsername(user.getLoginName());
        credentials.setPassword(new Password(DEFAULT_PASSWORD));
        TimeBasedOTP totp = new TimeBasedOTP();
        credentials.setToken(totp.generate(DEFAULT_TOTP_SECRET));
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credentials.getStatus());
        credentials.setToken(totp.generate(iphoneSecret));
        credentials.setDevice(iphoneDeviceName);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credentials.getStatus());
        credentials.setToken(totp.generate(androidSecret));
        credentials.setDevice(androidDeviceName);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credentials.getStatus());
        credentials.setToken(totp.generate(iphoneSecret));
        credentials.setDevice(androidDeviceName);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)credentials.getStatus());
        Assert.assertNull((Object)credentials.getValidatedAgent());
        credentials.setToken(totp.generate(androidSecret));
        credentials.setDevice(iphoneDeviceName);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)credentials.getStatus());
        Assert.assertNull((Object)credentials.getValidatedAgent());
    }

    @Test
    public void testDelayWindow() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        TOTPCredential credential = new TOTPCredential(DEFAULT_PASSWORD, DEFAULT_TOTP_SECRET);
        identityManager.updateCredential((Agent)user, (Object)credential);
        TOTPCredentials credentials = new TOTPCredentials();
        credentials.setUsername(user.getLoginName());
        credentials.setPassword(new Password(DEFAULT_PASSWORD));
        TimeBasedOTP totp = new TimeBasedOTP();
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -30);
        totp.setCalendar(calendar);
        String token = totp.generate(DEFAULT_TOTP_SECRET);
        credentials.setToken(token);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credentials.getStatus());
    }

    @Test
    public void testUpdatePasswordAndSecret() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        TOTPCredential credential = new TOTPCredential(DEFAULT_PASSWORD, DEFAULT_TOTP_SECRET);
        identityManager.updateCredential((Agent)user, (Object)credential);
        TOTPCredentials validatingCredential = new TOTPCredentials();
        validatingCredential.setUsername(user.getLoginName());
        validatingCredential.setPassword(new Password(DEFAULT_PASSWORD));
        TimeBasedOTP totp = new TimeBasedOTP();
        validatingCredential.setToken(totp.generate(DEFAULT_TOTP_SECRET));
        identityManager.validateCredentials((Credentials)validatingCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)validatingCredential.getStatus());
        credential = new TOTPCredential("new_password", DEFAULT_TOTP_SECRET);
        IDMUtil.sleep((int)1000);
        identityManager.updateCredential((Agent)user, (Object)credential);
        validatingCredential.setPassword(new Password("new_password"));
        validatingCredential.setToken(totp.generate(DEFAULT_TOTP_SECRET));
        identityManager.validateCredentials((Credentials)validatingCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)validatingCredential.getStatus());
        credential = new TOTPCredential("new_password", "new_secret");
        IDMUtil.sleep((int)1000);
        identityManager.updateCredential((Agent)user, (Object)credential);
        validatingCredential.setPassword(new Password("new_password"));
        validatingCredential.setToken(totp.generate("new_secret"));
        identityManager.validateCredentials((Credentials)validatingCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)validatingCredential.getStatus());
        validatingCredential.setPassword(new Password(DEFAULT_PASSWORD));
        validatingCredential.setToken(totp.generate(DEFAULT_TOTP_SECRET));
        identityManager.validateCredentials((Credentials)validatingCredential);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)validatingCredential.getStatus());
        Assert.assertNull((Object)validatingCredential.getValidatedAgent());
    }

    @Test
    public void testUpdateSecret() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        TOTPCredential credential = new TOTPCredential(DEFAULT_PASSWORD, DEFAULT_TOTP_SECRET);
        identityManager.updateCredential((Agent)user, (Object)credential);
        TOTPCredentials validatingCredential = new TOTPCredentials();
        validatingCredential.setUsername(user.getLoginName());
        validatingCredential.setPassword(new Password(DEFAULT_PASSWORD));
        TimeBasedOTP totp = new TimeBasedOTP();
        validatingCredential.setToken(totp.generate(DEFAULT_TOTP_SECRET));
        identityManager.validateCredentials((Credentials)validatingCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)validatingCredential.getStatus());
        credential = new TOTPCredential("new_secret");
        identityManager.updateCredential((Agent)user, (Object)credential);
        validatingCredential.setPassword(new Password(DEFAULT_PASSWORD));
        validatingCredential.setToken(totp.generate("new_secret"));
        identityManager.validateCredentials((Credentials)validatingCredential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)validatingCredential.getStatus());
    }

    @Test
    public void testInvalidToken() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        TOTPCredential credential = new TOTPCredential(DEFAULT_PASSWORD, DEFAULT_TOTP_SECRET);
        identityManager.updateCredential((Agent)user, (Object)credential);
        TOTPCredentials credentials = new TOTPCredentials();
        credentials.setUsername(user.getLoginName());
        credentials.setPassword(new Password(DEFAULT_PASSWORD));
        TimeBasedOTP totp = new TimeBasedOTP();
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -60);
        totp.setCalendar(calendar);
        String token = totp.generate(DEFAULT_TOTP_SECRET);
        credentials.setToken(token);
        identityManager.validateCredentials((Credentials)credentials);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)credentials.getStatus());
        Assert.assertNull((Object)credentials.getValidatedAgent());
    }
}

