/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.partition;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.Tier;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class TierManagementTestCase
extends AbstractIdentityManagerTestCase {
    private static final String APPLICATION_A_TIER_NAME = "Application A";
    private static final String APPLICATION_B_TIER_NAME = "Application B";
    private static final String APPLICATION_C_TIER_NAME = "Application C";

    @Test
    public void testRolesForTier() throws Exception {
        IdentityManager applicationTierIdentityManager = this.createIdentityManagerForTier(APPLICATION_A_TIER_NAME);
        SimpleRole testingRole = new SimpleRole("Role");
        applicationTierIdentityManager.add((IdentityType)testingRole);
        testingRole = applicationTierIdentityManager.getRole(testingRole.getName());
        Assert.assertNotNull((Object)testingRole);
        Assert.assertNotNull((Object)testingRole.getPartition());
        Assert.assertEquals((Object)APPLICATION_A_TIER_NAME, (Object)testingRole.getPartition().getId());
        IdentityManager identityManager = this.getIdentityManager();
        testingRole = identityManager.getRole(testingRole.getName());
        Assert.assertNull((Object)testingRole);
    }

    @Test
    public void testGroupsForTier() throws Exception {
        IdentityManager applicationA = this.createIdentityManagerForTier(APPLICATION_A_TIER_NAME);
        SimpleGroup testingGroup = new SimpleGroup("testingGroupTier");
        applicationA.add((IdentityType)testingGroup);
        testingGroup = applicationA.getGroup(testingGroup.getName());
        Assert.assertNotNull((Object)testingGroup);
        Assert.assertNotNull((Object)testingGroup.getPartition());
        Assert.assertEquals((Object)APPLICATION_A_TIER_NAME, (Object)testingGroup.getPartition().getId());
        IdentityManager identityManager = this.getIdentityManager();
        testingGroup = identityManager.getGroup(testingGroup.getName());
        Assert.assertNull((Object)testingGroup);
    }

    @Test
    public void testCreateSameRoleDifferentTiers() throws Exception {
        IdentityManager applicationA = this.createIdentityManagerForTier(APPLICATION_A_TIER_NAME);
        SimpleRole roleA = new SimpleRole("Role");
        applicationA.add((IdentityType)roleA);
        try {
            applicationA.add((IdentityType)new SimpleRole(roleA.getName()));
            Assert.fail();
        }
        catch (IdentityManagementException e) {
            // empty catch block
        }
        roleA = applicationA.getRole(roleA.getName());
        IdentityManager applicationB = this.createIdentityManagerForTier(APPLICATION_B_TIER_NAME);
        SimpleRole roleB = new SimpleRole("Role");
        applicationB.add((IdentityType)roleB);
        roleA = applicationA.getRole(roleA.getName());
        roleB = applicationB.getRole(roleB.getName());
        Assert.assertFalse((boolean)roleA.getId().equals(roleB.getId()));
    }

    @Test
    public void testCreateSameGroupDifferentTiers() throws Exception {
        IdentityManager applicationA = this.createIdentityManagerForTier(APPLICATION_A_TIER_NAME);
        SimpleGroup groupA = new SimpleGroup("Role");
        applicationA.add((IdentityType)groupA);
        try {
            applicationA.add((IdentityType)new SimpleGroup(groupA.getName()));
            Assert.fail();
        }
        catch (IdentityManagementException e) {
            // empty catch block
        }
        groupA = applicationA.getGroup(groupA.getName());
        IdentityManager applicationB = this.createIdentityManagerForTier(APPLICATION_B_TIER_NAME);
        SimpleGroup groupB = new SimpleGroup("Role");
        applicationB.add((IdentityType)groupB);
        groupA = applicationA.getGroup(groupA.getName());
        groupB = applicationB.getGroup(groupB.getName());
        Assert.assertFalse((boolean)groupA.getId().equals(groupB.getId()));
    }

    @Test
    public void testCreateSameGroupDifferentRealms() throws Exception {
        IdentityManager applicationA = this.createIdentityManagerForTier(APPLICATION_A_TIER_NAME);
        SimpleGroup groupA = new SimpleGroup("Group");
        applicationA.add((IdentityType)groupA);
        try {
            applicationA.add((IdentityType)new SimpleGroup(groupA.getName()));
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        groupA = applicationA.getGroup(groupA.getName());
        Assert.assertNotNull((Object)groupA);
        IdentityManager applicationB = this.createIdentityManagerForTier(APPLICATION_B_TIER_NAME);
        SimpleGroup groupB = new SimpleGroup("Group");
        applicationB.add((IdentityType)groupB);
        groupA = applicationA.getGroup(groupA.getName());
        groupB = applicationB.getGroup(groupB.getName());
        Assert.assertFalse((boolean)groupA.getId().equals(groupB.getId()));
    }

    @Test
    public void testGrantUserRoles() throws Exception {
        IdentityManager acmeRealm = this.getIdentityManager();
        SimpleUser john = new SimpleUser("John");
        SimpleUser bill = new SimpleUser("Bill");
        SimpleUser mary = new SimpleUser("Mary");
        acmeRealm.add((IdentityType)john);
        acmeRealm.add((IdentityType)bill);
        acmeRealm.add((IdentityType)mary);
        IdentityManager applicationA = this.createIdentityManagerForTier(APPLICATION_A_TIER_NAME);
        String roleAName = "Role A";
        String roleCName = "Role C";
        String roleBName = "Role B";
        applicationA.add((IdentityType)new SimpleRole(roleAName));
        IdentityManager applicationB = this.createIdentityManagerForTier(APPLICATION_B_TIER_NAME);
        applicationB.add((IdentityType)new SimpleRole(roleBName));
        IdentityManager applicationC = this.createIdentityManagerForTier(APPLICATION_C_TIER_NAME);
        applicationC.add((IdentityType)new SimpleRole(roleCName));
        Assert.assertNull((Object)acmeRealm.getRole(roleAName));
        Assert.assertNull((Object)acmeRealm.getRole(roleBName));
        Assert.assertNull((Object)acmeRealm.getRole(roleCName));
        acmeRealm.grantRole((IdentityType)john, applicationA.getRole(roleAName));
        acmeRealm.grantRole((IdentityType)bill, applicationB.getRole(roleBName));
        acmeRealm.grantRole((IdentityType)mary, applicationC.getRole(roleCName));
        Assert.assertTrue((boolean)acmeRealm.hasRole((IdentityType)john, applicationA.getRole(roleAName)));
        Assert.assertFalse((boolean)acmeRealm.hasRole((IdentityType)john, applicationB.getRole(roleBName)));
        Assert.assertFalse((boolean)acmeRealm.hasRole((IdentityType)john, applicationC.getRole(roleCName)));
        Assert.assertTrue((boolean)acmeRealm.hasRole((IdentityType)bill, applicationB.getRole(roleBName)));
        Assert.assertFalse((boolean)acmeRealm.hasRole((IdentityType)bill, applicationA.getRole(roleAName)));
        Assert.assertFalse((boolean)acmeRealm.hasRole((IdentityType)bill, applicationC.getRole(roleCName)));
        Assert.assertTrue((boolean)acmeRealm.hasRole((IdentityType)mary, applicationC.getRole(roleCName)));
        Assert.assertFalse((boolean)acmeRealm.hasRole((IdentityType)mary, applicationA.getRole(roleAName)));
        Assert.assertFalse((boolean)acmeRealm.hasRole((IdentityType)mary, applicationB.getRole(roleBName)));
        acmeRealm.grantRole((IdentityType)john, applicationB.getRole(roleBName));
        Assert.assertTrue((boolean)acmeRealm.hasRole((IdentityType)john, applicationA.getRole(roleAName)));
        Assert.assertTrue((boolean)acmeRealm.hasRole((IdentityType)john, applicationB.getRole(roleBName)));
        Assert.assertFalse((boolean)acmeRealm.hasRole((IdentityType)john, applicationC.getRole(roleCName)));
        applicationA.remove((IdentityType)applicationA.getRole(roleAName));
        Assert.assertNull((Object)applicationA.getRole(roleAName));
        Assert.assertTrue((boolean)acmeRealm.hasRole((IdentityType)bill, applicationB.getRole(roleBName)));
        Assert.assertTrue((boolean)acmeRealm.hasRole((IdentityType)mary, applicationC.getRole(roleCName)));
        acmeRealm.revokeRole((IdentityType)bill, applicationB.getRole(roleBName));
        Assert.assertFalse((boolean)acmeRealm.hasRole((IdentityType)bill, applicationB.getRole(roleBName)));
        Assert.assertTrue((boolean)acmeRealm.hasRole((IdentityType)mary, applicationC.getRole(roleCName)));
        acmeRealm.remove((IdentityType)john);
        acmeRealm.remove((IdentityType)bill);
        acmeRealm.remove((IdentityType)mary);
        Assert.assertFalse((boolean)acmeRealm.hasRole((IdentityType)bill, applicationB.getRole(roleBName)));
        Assert.assertFalse((boolean)acmeRealm.hasRole((IdentityType)mary, applicationC.getRole(roleCName)));
    }

    @Test
    public void testGrantUserGroups() throws Exception {
        IdentityManager acmeRealm = this.getIdentityManager();
        SimpleUser john = new SimpleUser("John");
        SimpleUser bill = new SimpleUser("Bill");
        SimpleUser mary = new SimpleUser("Mary");
        acmeRealm.add((IdentityType)john);
        acmeRealm.add((IdentityType)bill);
        acmeRealm.add((IdentityType)mary);
        IdentityManager applicationA = this.createIdentityManagerForTier(APPLICATION_A_TIER_NAME);
        applicationA.add((IdentityType)new SimpleGroup("Group A"));
        IdentityManager applicationB = this.createIdentityManagerForTier(APPLICATION_B_TIER_NAME);
        applicationB.add((IdentityType)new SimpleGroup("Group B"));
        IdentityManager applicationC = this.createIdentityManagerForTier(APPLICATION_C_TIER_NAME);
        applicationC.add((IdentityType)new SimpleGroup("Group C"));
        acmeRealm.addToGroup((Agent)john, applicationA.getGroup("Group A"));
        acmeRealm.addToGroup((Agent)bill, applicationB.getGroup("Group B"));
        acmeRealm.addToGroup((Agent)mary, applicationC.getGroup("Group C"));
        Assert.assertTrue((boolean)acmeRealm.isMember((IdentityType)john, applicationA.getGroup("Group A")));
        Assert.assertFalse((boolean)acmeRealm.isMember((IdentityType)john, applicationB.getGroup("Group B")));
        Assert.assertFalse((boolean)acmeRealm.isMember((IdentityType)john, applicationC.getGroup("Group C")));
        Assert.assertTrue((boolean)acmeRealm.isMember((IdentityType)bill, applicationB.getGroup("Group B")));
        Assert.assertFalse((boolean)acmeRealm.isMember((IdentityType)bill, applicationA.getGroup("Group A")));
        Assert.assertFalse((boolean)acmeRealm.isMember((IdentityType)bill, applicationC.getGroup("Group C")));
        Assert.assertTrue((boolean)acmeRealm.isMember((IdentityType)mary, applicationC.getGroup("Group C")));
        Assert.assertFalse((boolean)acmeRealm.isMember((IdentityType)mary, applicationA.getGroup("Group A")));
        Assert.assertFalse((boolean)acmeRealm.isMember((IdentityType)mary, applicationB.getGroup("Group B")));
    }

    @Test
    public void testGrantSameRoleToTierAndRealm() throws Exception {
        IdentityManager acmeRealm = this.getIdentityManager();
        SimpleRole realmRole = new SimpleRole("Role");
        acmeRealm.add((IdentityType)realmRole);
        IdentityManager application = this.createIdentityManagerForTier(APPLICATION_A_TIER_NAME);
        SimpleRole applicationRole = new SimpleRole("Role");
        application.add((IdentityType)applicationRole);
        realmRole = acmeRealm.getRole("Role");
        applicationRole = application.getRole("Role");
        Assert.assertFalse((boolean)realmRole.getId().equals(applicationRole.getId()));
        applicationRole = new SimpleRole("Another Role");
        application.add((IdentityType)applicationRole);
        Assert.assertNull((Object)acmeRealm.getRole("Another Role"));
        realmRole = new SimpleRole("Another Role");
        acmeRealm.add((IdentityType)realmRole);
        Assert.assertNotNull((Object)application.getRole("Another Role"));
        Assert.assertFalse((boolean)realmRole.getId().equals(applicationRole.getId()));
    }

    @Test
    public void failAddUserToTier() throws Exception {
        Tier applicationTier = new Tier(APPLICATION_A_TIER_NAME);
        try {
            this.createUser("testingUserTier", (Partition)applicationTier);
        }
        catch (IdentityManagementException ime) {
            Assert.assertTrue((boolean)ime.getMessage().contains("PLIDM000067"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    private IdentityManager createIdentityManagerForTier(String tierName) {
        return this.getIdentityManagerFactory().createIdentityManager((Partition)this.getIdentityManagerFactory().getTier(tierName));
    }
}

