/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.performance;

import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleUser;

public class FileIdentityStoreLoadUsersJMeterTest
extends AbstractJavaSamplerClient {
    private static IdentityManagerFactory identityManagerFactory = null;

    public Arguments getDefaultParameters() {
        Arguments arguments = new Arguments();
        arguments.addArgument("loginName", "Sample User");
        return arguments;
    }

    public void setupTest(JavaSamplerContext context) {
    }

    public void teardownTest(JavaSamplerContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult runTest(JavaSamplerContext context) {
        SampleResult result = new SampleResult();
        result.sampleStart();
        boolean success = false;
        String loginName = context.getParameter("loginName");
        if (loginName == null) {
            loginName = "Sample User";
        }
        JMeterVariables vars = JMeterContextService.getContext().getVariables();
        vars.put("loginName", loginName);
        try {
            SimpleUser user = new SimpleUser(loginName);
            IdentityManager identityManager = identityManagerFactory.createIdentityManager();
            identityManager.add((IdentityType)user);
            success = user.getId() != null && identityManager.getUser(loginName) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            result.sampleEnd();
            result.setSuccessful(success);
        }
        return result;
    }

    private static IdentityManagerFactory createIdentityManagerFactory() {
        return identityManagerFactory;
    }

    static {
        identityManagerFactory = FileIdentityStoreLoadUsersJMeterTest.createIdentityManagerFactory();
    }
}

