/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.ExcludeTestSuite;
import org.picketlink.test.idm.query.AbstractIdentityQueryTestCase;
import org.picketlink.test.idm.suites.LDAPIdentityStoreTestSuite;
import org.picketlink.test.idm.suites.LDAPIdentityStoreWithoutAttributesTestSuite;
import org.picketlink.test.idm.suites.LDAPJPAMixedStoreTestSuite;

public class GroupQueryTestCase
extends AbstractIdentityQueryTestCase<Group> {
    @Override
    protected Group createIdentityType(String name, Partition partition) {
        if (name == null) {
            name = "someGroup";
        }
        return this.createGroup(name, null, partition);
    }

    @Override
    protected Group getIdentityType() {
        return this.getIdentityManager().getGroup("someGroup");
    }

    @After
    public void onFinish() {
        IdentityQuery query = this.getIdentityManager().createIdentityQuery(Group.class);
        List result = query.getResultList();
        for (Group group : result) {
            this.getIdentityManager().remove((IdentityType)group);
        }
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPJPAMixedStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindByTier() throws Exception {
        SimpleGroup someGroup = new SimpleGroup("someGroup");
        Tier applicationATier = this.getIdentityManagerFactory().getTier("Application A");
        IdentityManager applicationA = this.getIdentityManagerFactory().createIdentityManager((Partition)applicationATier);
        applicationA.add((IdentityType)someGroup);
        IdentityQuery query = applicationA.createIdentityQuery(Group.class);
        query.setParameter(Group.PARTITION, new Object[]{applicationATier});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getId()));
        Tier applicationBTier = this.getIdentityManagerFactory().getTier("Application B");
        IdentityManager applicationB = this.getIdentityManagerFactory().createIdentityManager((Partition)applicationBTier);
        SimpleGroup anotherRole = new SimpleGroup("anotherRole");
        applicationB.add((IdentityType)anotherRole);
        query = applicationB.createIdentityQuery(Group.class);
        query.setParameter(Group.PARTITION, new Object[]{applicationBTier});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, anotherRole.getId()));
    }

    @Test
    public void testFindByName() throws Exception {
        Group group = this.createGroup("admin", null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.NAME, new Object[]{group.getName()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertEquals((String)group.getId(), (String)((Group)result.get(0)).getId());
    }

    @Test
    public void testFindWithParent() throws Exception {
        Group group = this.createGroup("someGroup", "Parent Group");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.PARENT, new Object[]{group.getParentGroup().getName()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertEquals((String)group.getId(), (String)((Group)result.get(0)).getId());
        Assert.assertEquals((String)group.getParentGroup().getId(), (String)((Group)result.get(0)).getParentGroup().getId());
    }

    @Test
    public void testFindGroupMembers() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        SimpleGroup groupA = new SimpleGroup("a");
        identityManager.add((IdentityType)groupA);
        SimpleGroup groupB = new SimpleGroup("b", (Group)groupA);
        identityManager.add((IdentityType)groupB);
        SimpleGroup groupC = new SimpleGroup("c", (Group)groupB);
        identityManager.add((IdentityType)groupC);
        SimpleGroup groupD = new SimpleGroup("d", (Group)groupC);
        identityManager.add((IdentityType)groupD);
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{groupA});
        List result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{groupB});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, groupA.getId()));
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{groupC});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, groupA.getId()));
        Assert.assertTrue((boolean)this.contains(result, groupB.getId()));
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{groupD});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, groupA.getId()));
        Assert.assertTrue((boolean)this.contains(result, groupB.getId()));
        Assert.assertTrue((boolean)this.contains(result, groupC.getId()));
    }

    @Test
    public void testFindUserGroups() throws Exception {
        Group someGroup = this.createGroup("someGroup", null);
        Group someAnotherGroup = this.createGroup("someAnotherGroup", null);
        Group someImportantGroup = this.createGroup("someImportantGroup", null);
        User user = this.createUser("someUser");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someGroup.getId()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherGroup.getId()));
        Assert.assertFalse((boolean)this.contains(result, someImportantGroup.getId()));
        identityManager.addToGroup((Agent)user, someGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getId()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherGroup.getId()));
        Assert.assertFalse((boolean)this.contains(result, someImportantGroup.getId()));
        identityManager.addToGroup((Agent)user, someAnotherGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getId()));
        Assert.assertFalse((boolean)this.contains(result, someImportantGroup.getId()));
        identityManager.addToGroup((Agent)user, someImportantGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someGroup.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherGroup.getId()));
        Assert.assertTrue((boolean)this.contains(result, someImportantGroup.getId()));
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPJPAMixedStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindWithSorting() throws Exception {
        this.createGroup("someGroup", null);
        IDMUtil.sleep((int)1000);
        this.createGroup("someAnotherGroup", null);
        IDMUtil.sleep((int)1000);
        this.createGroup("someImportantGroup", null);
        IdentityQuery groupQuery = this.getIdentityManager().createIdentityQuery(Group.class);
        List groups = groupQuery.getResultList();
        Assert.assertEquals((int)3, (int)groups.size());
        Assert.assertEquals((String)((Group)groups.get(0)).getName(), (String)"someAnotherGroup");
        Assert.assertEquals((String)((Group)groups.get(1)).getName(), (String)"someGroup");
        Assert.assertEquals((String)((Group)groups.get(2)).getName(), (String)"someImportantGroup");
        groupQuery = this.getIdentityManager().createIdentityQuery(Group.class);
        groupQuery.setSortAscending(false);
        groupQuery.setSortParameters(new QueryParameter[]{IdentityType.ENABLED, IdentityType.CREATED_DATE});
        groups = groupQuery.getResultList();
        Assert.assertEquals((int)3, (int)groups.size());
        Assert.assertEquals((String)((Group)groups.get(0)).getName(), (String)"someImportantGroup");
        Assert.assertEquals((String)((Group)groups.get(1)).getName(), (String)"someAnotherGroup");
        Assert.assertEquals((String)((Group)groups.get(2)).getName(), (String)"someGroup");
    }
}

