/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class IdentityTypeQueryTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testFindByDifferentRealms() {
        IdentityManager identityManager = this.getIdentityManager();
        SimpleAgent agent = new SimpleAgent("Agent");
        identityManager.add((IdentityType)agent);
        SimpleUser user = new SimpleUser("User");
        identityManager.add((IdentityType)user);
        SimpleRole role = new SimpleRole("Role");
        identityManager.add((IdentityType)role);
        SimpleGroup group = new SimpleGroup("Group");
        identityManager.add((IdentityType)group);
        IdentityQuery query = identityManager.createIdentityQuery(IdentityType.class);
        query.setParameter(IdentityType.PARTITION, new Object[]{"default"});
        List result = query.getResultList();
        Assert.assertEquals((int)4, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, agent.getId()));
        Assert.assertTrue((boolean)this.contains(result, user.getId()));
        Assert.assertTrue((boolean)this.contains(result, role.getId()));
        Assert.assertTrue((boolean)this.contains(result, group.getId()));
        IdentityManager testingRealm = this.getIdentityManagerFactory().createIdentityManager((Partition)this.getIdentityManagerFactory().getRealm("Testing"));
        agent = new SimpleAgent("Another Agent");
        testingRealm.add((IdentityType)agent);
        user = new SimpleUser("Another User");
        testingRealm.add((IdentityType)user);
        role = new SimpleRole("Another Role");
        testingRealm.add((IdentityType)role);
        group = new SimpleGroup("Another Group");
        testingRealm.add((IdentityType)group);
        query = testingRealm.createIdentityQuery(IdentityType.class);
        query.setParameter(IdentityType.PARTITION, new Object[]{"Testing"});
        result = query.getResultList();
        Assert.assertEquals((int)4, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, agent.getId()));
        Assert.assertTrue((boolean)this.contains(result, user.getId()));
        Assert.assertTrue((boolean)this.contains(result, role.getId()));
        Assert.assertTrue((boolean)this.contains(result, group.getId()));
    }

    @Test
    public void testFindByDifferentTiers() {
        IdentityManager identityManager = this.getIdentityManagerFactory().createIdentityManager((Partition)this.getIdentityManagerFactory().getTier("Application A"));
        SimpleRole role = new SimpleRole("Role");
        identityManager.add((IdentityType)role);
        SimpleGroup group = new SimpleGroup("Group");
        identityManager.add((IdentityType)group);
        IdentityQuery query = identityManager.createIdentityQuery(IdentityType.class);
        query.setParameter(IdentityType.PARTITION, new Object[]{"Application A"});
        List result = query.getResultList();
        Assert.assertEquals((int)2, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, role.getId()));
        Assert.assertTrue((boolean)this.contains(result, group.getId()));
        IdentityManager testingRealm = this.getIdentityManagerFactory().createIdentityManager((Partition)this.getIdentityManagerFactory().getTier("Application B"));
        role = new SimpleRole("Another Role");
        testingRealm.add((IdentityType)role);
        group = new SimpleGroup("Another Group");
        testingRealm.add((IdentityType)group);
        query = testingRealm.createIdentityQuery(IdentityType.class);
        query.setParameter(IdentityType.PARTITION, new Object[]{"Application B"});
        result = query.getResultList();
        Assert.assertEquals((int)2, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, role.getId()));
        Assert.assertTrue((boolean)this.contains(result, group.getId()));
    }

    protected boolean contains(List<IdentityType> result, String id) {
        for (IdentityType identityType : result) {
            if (!identityType.getId().equals(id)) continue;
            return true;
        }
        return false;
    }
}

