/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.ExcludeTestSuite;
import org.picketlink.test.idm.query.AbstractIdentityQueryTestCase;
import org.picketlink.test.idm.suites.LDAPIdentityStoreTestSuite;
import org.picketlink.test.idm.suites.LDAPIdentityStoreWithoutAttributesTestSuite;
import org.picketlink.test.idm.suites.LDAPJPAMixedStoreTestSuite;

public class RoleQueryTestCase
extends AbstractIdentityQueryTestCase<Role> {
    @Override
    protected Role createIdentityType(String name, Partition partition) {
        if (name == null) {
            name = "someRole";
        }
        return this.createRole(name, partition);
    }

    @Override
    protected Role getIdentityType() {
        return this.getIdentityManager().getRole("someRole");
    }

    @After
    public void onFinish() {
        IdentityQuery query = this.getIdentityManager().createIdentityQuery(Role.class);
        List result = query.getResultList();
        for (Role role : result) {
            this.getIdentityManager().remove((IdentityType)role);
        }
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPJPAMixedStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindByTier() throws Exception {
        SimpleRole someRole = new SimpleRole("someRole");
        Tier applicationATier = this.getIdentityManagerFactory().getTier("Application A");
        IdentityManager applicationA = this.getIdentityManagerFactory().createIdentityManager((Partition)applicationATier);
        applicationA.add((IdentityType)someRole);
        IdentityQuery query = applicationA.createIdentityQuery(Role.class);
        query.setParameter(Role.PARTITION, new Object[]{applicationATier});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, someRole.getId()));
        Tier applicationBTier = this.getIdentityManagerFactory().getTier("Application B");
        IdentityManager applicationB = this.getIdentityManagerFactory().createIdentityManager((Partition)applicationBTier);
        SimpleRole anotherRole = new SimpleRole("anotherRole");
        applicationB.add((IdentityType)anotherRole);
        query = applicationB.createIdentityQuery(Role.class);
        query.setParameter(Role.PARTITION, new Object[]{applicationBTier});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, anotherRole.getId()));
    }

    @Test
    public void testFindByName() throws Exception {
        Role role = this.createRole("admin");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.NAME, new Object[]{"admin"});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertEquals((String)role.getId(), (String)((Role)result.get(0)).getId());
    }

    @Test
    public void testFindUserRoles() throws Exception {
        Role someRole = this.createRole("someRole");
        Role someAnotherRole = this.createRole("someAnotherRole");
        Role someImportantRole = this.createRole("someImportantRole");
        User user = this.createUser("someUser");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, someRole.getId()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherRole.getId()));
        Assert.assertFalse((boolean)this.contains(result, someImportantRole.getId()));
        identityManager.grantRole((IdentityType)user, someRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getId()));
        Assert.assertFalse((boolean)this.contains(result, someAnotherRole.getId()));
        Assert.assertFalse((boolean)this.contains(result, someImportantRole.getId()));
        identityManager.grantRole((IdentityType)user, someAnotherRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getId()));
        Assert.assertFalse((boolean)this.contains(result, someImportantRole.getId()));
        identityManager.grantRole((IdentityType)user, someImportantRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, someRole.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getId()));
        Assert.assertTrue((boolean)this.contains(result, someImportantRole.getId()));
        identityManager.revokeRole((IdentityType)user, someRole);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertFalse((boolean)this.contains(result, someRole.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getId()));
        Assert.assertTrue((boolean)this.contains(result, someImportantRole.getId()));
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPJPAMixedStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindWithSorting() throws Exception {
        this.createRole("someRole");
        this.createRole("someAnotherRole");
        this.createRole("someImportantRole");
        IdentityQuery roleQuery = this.getIdentityManager().createIdentityQuery(Role.class);
        roleQuery.setSortAscending(false);
        List roles = roleQuery.getResultList();
        Assert.assertEquals((int)3, (int)roles.size());
        Assert.assertEquals((String)((Role)roles.get(0)).getName(), (String)"someRole");
        Assert.assertEquals((String)((Role)roles.get(1)).getName(), (String)"someImportantRole");
        Assert.assertEquals((String)((Role)roles.get(2)).getName(), (String)"someAnotherRole");
    }
}

