/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.relationship;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;
import org.picketlink.test.idm.relationship.CustomRelationship;

public class CustomRelationshipTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testCreate() throws Exception {
        CustomRelationship relationship = new CustomRelationship();
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("user");
        relationship.setIdentityTypeA((IdentityType)user);
        Role role = this.createRole("role");
        relationship.setIdentityTypeB((IdentityType)role);
        Group group = this.createGroup("group");
        relationship.setIdentityTypeC((IdentityType)group);
        relationship.setAttributeA("A");
        relationship.setAttributeB("B");
        relationship.setAttributeC("C");
        identityManager.add((Relationship)relationship);
        RelationshipQuery query = identityManager.createRelationshipQuery(CustomRelationship.class);
        query.setParameter((QueryParameter)CustomRelationship.IDENTITY_TYPE_A, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)relationship.getId(), (Object)((CustomRelationship)((Object)result.get(0))).getId());
        Assert.assertEquals((Object)relationship.getAttributeA(), (Object)((CustomRelationship)((Object)result.get(0))).getAttributeA());
        Assert.assertEquals((Object)relationship.getAttributeB(), (Object)((CustomRelationship)((Object)result.get(0))).getAttributeB());
        Assert.assertEquals((Object)relationship.getAttributeC(), (Object)((CustomRelationship)((Object)result.get(0))).getAttributeC());
        query = identityManager.createRelationshipQuery(CustomRelationship.class);
        query.setParameter((QueryParameter)CustomRelationship.IDENTITY_TYPE_B, new Object[]{role});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)relationship.getId(), (Object)((CustomRelationship)((Object)result.get(0))).getId());
        query = identityManager.createRelationshipQuery(CustomRelationship.class);
        query.setParameter((QueryParameter)CustomRelationship.IDENTITY_TYPE_C, new Object[]{group});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)relationship.getId(), (Object)((CustomRelationship)((Object)result.get(0))).getId());
        query = identityManager.createRelationshipQuery(CustomRelationship.class);
        query.setParameter((QueryParameter)CustomRelationship.IDENTITY_TYPE_A, new Object[]{user});
        query.setParameter((QueryParameter)CustomRelationship.IDENTITY_TYPE_B, new Object[]{role});
        query.setParameter((QueryParameter)CustomRelationship.IDENTITY_TYPE_C, new Object[]{group});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)relationship.getId(), (Object)((CustomRelationship)((Object)result.get(0))).getId());
    }
}

