/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.suites;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.junit.After;
import org.junit.Before;
import org.picketbox.test.ldap.AbstractLDAPTest;

public abstract class LDAPAbstractSuite
extends AbstractLDAPTest {
    static final String BASE_DN = "dc=jboss,dc=org";
    static final String LDAP_URL = "ldap://localhost:10389";
    static final String ROLES_DN_SUFFIX = "ou=Roles,dc=jboss,dc=org";
    static final String GROUP_DN_SUFFIX = "ou=Groups,dc=jboss,dc=org";
    static final String USER_DN_SUFFIX = "ou=People,dc=jboss,dc=org";
    static final String AGENT_DN_SUFFIX = "ou=Agent,dc=jboss,dc=org";
    static final String CONNECTION_PROPERTIES = "config/ldap-connection.properties";
    protected String connectionUrl = "ldap://localhost:10389";
    protected String baseDn = "dc=jboss,dc=org";
    protected String userDnSuffix = "ou=People,dc=jboss,dc=org";
    protected String rolesDnSuffix = "ou=Roles,dc=jboss,dc=org";
    protected String groupDnSuffix = "ou=Groups,dc=jboss,dc=org";
    protected String agentDnSuffix = "ou=Agent,dc=jboss,dc=org";
    protected boolean startEmbeddedLdapLerver = true;
    protected String bindDn = "uid=admin,ou=system";
    protected String bindCredential = "secret";
    public static String IDM_TEST_LDAP_CONNECTION_URL = "idm.test.ldap.connection.url";
    public static String IDM_TEST_LDAP_BASE_DN = "idm.test.ldap.base.dn";
    public static String IDM_TEST_LDAP_ROLES_DN_SUFFIX = "idm.test.ldap.roles.dn.suffix";
    public static String IDM_TEST_LDAP_GROUP_DN_SUFFIX = "idm.test.ldap.group.dn.suffix";
    public static String IDM_TEST_LDAP_USER_DN_SUFFIX = "idm.test.ldap.user.dn.suffix";
    public static String IDM_TEST_LDAP_AGENT_DN_SUFFIX = "idm.test.ldap.agent.dn.suffix";
    public static String IDM_TEST_LDAP_START_EMBEDDED_LDAP_SERVER = "idm.test.ldap.start.embedded.ldap.server";
    public static String IDM_TEST_LDAP_BIND_DN = "idm.test.ldap.bind.dn";
    public static String IDM_TEST_LDAP_BIND_CREDENTIAL = "idm.test.ldap.bind.credential";

    public LDAPAbstractSuite() {
        this.loadConnectionProperties();
    }

    protected void loadConnectionProperties() {
        Properties p = new Properties();
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(CONNECTION_PROPERTIES);
            p.load(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.connectionUrl = p.getProperty(IDM_TEST_LDAP_CONNECTION_URL, LDAP_URL);
        this.baseDn = p.getProperty(IDM_TEST_LDAP_BASE_DN, BASE_DN);
        this.userDnSuffix = p.getProperty(IDM_TEST_LDAP_USER_DN_SUFFIX, USER_DN_SUFFIX);
        this.rolesDnSuffix = p.getProperty(IDM_TEST_LDAP_ROLES_DN_SUFFIX, ROLES_DN_SUFFIX);
        this.groupDnSuffix = p.getProperty(IDM_TEST_LDAP_GROUP_DN_SUFFIX, GROUP_DN_SUFFIX);
        this.agentDnSuffix = p.getProperty(IDM_TEST_LDAP_AGENT_DN_SUFFIX, AGENT_DN_SUFFIX);
        this.startEmbeddedLdapLerver = Boolean.parseBoolean(p.getProperty(IDM_TEST_LDAP_START_EMBEDDED_LDAP_SERVER, "true"));
        this.bindDn = p.getProperty(IDM_TEST_LDAP_BIND_DN, this.bindDn);
        this.bindCredential = p.getProperty(IDM_TEST_LDAP_BIND_CREDENTIAL, this.bindCredential);
    }

    @Before
    public void setup() throws Exception {
        if (this.isStartEmbeddedLdapLerver()) {
            super.setup();
        }
    }

    @After
    public void tearDown() throws Exception {
        DirContext ctx = this.getDirContext();
        LDAPAbstractSuite.clearSubContexts(ctx, new CompositeName(this.baseDn));
        if (this.isStartEmbeddedLdapLerver()) {
            super.tearDown();
        }
    }

    private DirContext getDirContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.connectionUrl);
        env.put("java.naming.security.principal", this.bindDn);
        env.put("java.naming.security.credentials", this.bindCredential);
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSubContexts(DirContext ctx, Name name) throws NamingException {
        NamingEnumeration<NameClassPair> enumeration = null;
        try {
            enumeration = ctx.list(name);
            while (enumeration.hasMore()) {
                NameClassPair pair = enumeration.next();
                Name childName = ctx.composeName(new CompositeName(pair.getName()), name);
                try {
                    ctx.destroySubcontext(childName);
                }
                catch (ContextNotEmptyException e) {
                    LDAPAbstractSuite.clearSubContexts(ctx, childName);
                    ctx.destroySubcontext(childName);
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                enumeration.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public String getUserDnSuffix() {
        return this.userDnSuffix;
    }

    public String getRolesDnSuffix() {
        return this.rolesDnSuffix;
    }

    public String getGroupDnSuffix() {
        return this.groupDnSuffix;
    }

    public String getAgentDnSuffix() {
        return this.agentDnSuffix;
    }

    public boolean isStartEmbeddedLdapLerver() {
        return this.startEmbeddedLdapLerver;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public String getBindCredential() {
        return this.bindCredential;
    }

    public void importLDIF(String fileName) throws Exception {
        if (this.isStartEmbeddedLdapLerver()) {
            super.importLDIF(fileName);
        }
    }
}

