/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.suites;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.test.idm.IdentityManagerRunner;
import org.picketlink.test.idm.TestLifecycle;
import org.picketlink.test.idm.basic.AgentManagementTestCase;
import org.picketlink.test.idm.basic.GroupManagementTestCase;
import org.picketlink.test.idm.basic.RoleManagementTestCase;
import org.picketlink.test.idm.basic.UserManagementTestCase;
import org.picketlink.test.idm.credential.PasswordCredentialTestCase;
import org.picketlink.test.idm.query.AgentQueryTestCase;
import org.picketlink.test.idm.query.GroupQueryTestCase;
import org.picketlink.test.idm.query.RelationshipQueryTestCase;
import org.picketlink.test.idm.query.RoleQueryTestCase;
import org.picketlink.test.idm.query.UserQueryTestCase;
import org.picketlink.test.idm.relationship.AgentGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.AgentGroupRoleRelationshipTestCase;
import org.picketlink.test.idm.relationship.AgentGroupsRelationshipTestCase;
import org.picketlink.test.idm.relationship.GroupGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.GroupMembershipTestCase;
import org.picketlink.test.idm.relationship.UserGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.UserGroupRoleRelationshipTestCase;
import org.picketlink.test.idm.suites.LDAPAbstractSuite;

@RunWith(value=IdentityManagerRunner.class)
@Suite.SuiteClasses(value={RelationshipQueryTestCase.class, UserManagementTestCase.class, PasswordCredentialTestCase.class, RoleManagementTestCase.class, GroupManagementTestCase.class, AgentManagementTestCase.class, AgentQueryTestCase.class, UserQueryTestCase.class, RoleQueryTestCase.class, GroupQueryTestCase.class, AgentGroupRoleRelationshipTestCase.class, AgentGroupsRelationshipTestCase.class, UserGrantRelationshipTestCase.class, AgentGrantRelationshipTestCase.class, GroupGrantRelationshipTestCase.class, UserGroupRoleRelationshipTestCase.class, GroupMembershipTestCase.class})
public class LDAPIdentityStoreTestSuite
extends LDAPAbstractSuite
implements TestLifecycle {
    private static LDAPIdentityStoreTestSuite instance;

    public static TestLifecycle init() throws Exception {
        if (instance == null) {
            instance = new LDAPIdentityStoreTestSuite();
        }
        return instance;
    }

    @BeforeClass
    public static void onBeforeClass() {
        try {
            LDAPIdentityStoreTestSuite.init();
            instance.setup();
            instance.importLDIF("ldap/users.ldif");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void onDestroyClass() {
        try {
            instance.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public IdentityManagerFactory createIdentityManagerFactory() {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        builder.stores().ldap().baseDN(this.getBaseDn()).bindDN(this.getBindDn()).bindCredential(this.getBindCredential()).url(this.getConnectionUrl()).userDNSuffix(this.getUserDnSuffix()).roleDNSuffix(this.getRolesDnSuffix()).agentDNSuffix(this.getAgentDnSuffix()).groupDNSuffix(this.getGroupDnSuffix()).addGroupMapping("/QA Group", "ou=QA," + this.getBaseDn()).supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.agent, FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.group, FeatureSet.FeatureGroup.role, FeatureSet.FeatureGroup.attribute, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureGroup.credential});
        return new IdentityManagerFactory(builder.build());
    }
}

