/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.suites;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.test.idm.IdentityManagerRunner;
import org.picketlink.test.idm.TestLifecycle;
import org.picketlink.test.idm.basic.AgentManagementTestCase;
import org.picketlink.test.idm.basic.GroupManagementTestCase;
import org.picketlink.test.idm.basic.RoleManagementTestCase;
import org.picketlink.test.idm.basic.UserManagementTestCase;
import org.picketlink.test.idm.credential.PasswordCredentialTestCase;
import org.picketlink.test.idm.query.AgentQueryTestCase;
import org.picketlink.test.idm.query.GroupQueryTestCase;
import org.picketlink.test.idm.query.RelationshipQueryTestCase;
import org.picketlink.test.idm.query.RoleQueryTestCase;
import org.picketlink.test.idm.query.UserQueryTestCase;
import org.picketlink.test.idm.relationship.AgentGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.AgentGroupRoleRelationshipTestCase;
import org.picketlink.test.idm.relationship.AgentGroupsRelationshipTestCase;
import org.picketlink.test.idm.relationship.GroupGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.GroupMembershipTestCase;
import org.picketlink.test.idm.relationship.UserGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.UserGroupRoleRelationshipTestCase;
import org.picketlink.test.idm.suites.LDAPAbstractSuite;

@RunWith(value=IdentityManagerRunner.class)
@Suite.SuiteClasses(value={RelationshipQueryTestCase.class, UserManagementTestCase.class, PasswordCredentialTestCase.class, RoleManagementTestCase.class, GroupManagementTestCase.class, AgentManagementTestCase.class, AgentQueryTestCase.class, UserQueryTestCase.class, RoleQueryTestCase.class, GroupQueryTestCase.class, AgentGroupRoleRelationshipTestCase.class, AgentGroupsRelationshipTestCase.class, UserGrantRelationshipTestCase.class, AgentGrantRelationshipTestCase.class, GroupGrantRelationshipTestCase.class, UserGroupRoleRelationshipTestCase.class, GroupMembershipTestCase.class})
public class LDAPIdentityStoreWithoutAttributesTestSuite
extends LDAPAbstractSuite
implements TestLifecycle {
    private static LDAPIdentityStoreWithoutAttributesTestSuite instance;

    public static TestLifecycle init() throws Exception {
        if (instance == null) {
            instance = new LDAPIdentityStoreWithoutAttributesTestSuite();
        }
        return instance;
    }

    @BeforeClass
    public static void onBeforeClass() {
        try {
            LDAPIdentityStoreWithoutAttributesTestSuite.init();
            instance.setup();
            instance.importLDIF("ldap/users.ldif");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void onDestroyClass() {
        try {
            instance.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public IdentityManagerFactory createIdentityManagerFactory() {
        IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
        ((LDAPStoreConfigurationBuilder)builder.stores().ldap().baseDN(this.getBaseDn()).bindDN(this.getBindDn()).bindCredential(this.getBindCredential()).url(this.getConnectionUrl()).userDNSuffix(this.getUserDnSuffix()).roleDNSuffix(this.getRolesDnSuffix()).agentDNSuffix(this.getAgentDnSuffix()).groupDNSuffix(this.getGroupDnSuffix()).addGroupMapping("/QA Group", "ou=QA," + this.getBaseDn()).supportAllFeatures()).removeFeature(FeatureSet.FeatureGroup.attribute);
        return new IdentityManagerFactory(builder.build());
    }
}

