/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.basic;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.test.idm.basic.AbstractIdentityTypeTestCase;

public class GroupManagementTestCase
extends AbstractIdentityTypeTestCase<Group> {
    @Test
    public void testCreate() throws Exception {
        Group newGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        Group storedGroup = identityManager.getGroup(newGroup.getName());
        Assert.assertNotNull((Object)storedGroup);
        junit.framework.Assert.assertEquals((String)newGroup.getId(), (String)storedGroup.getId());
        junit.framework.Assert.assertEquals((String)newGroup.getName(), (String)storedGroup.getName());
        Assert.assertNotNull((Object)storedGroup.getPartition());
        junit.framework.Assert.assertEquals((String)"default", (String)storedGroup.getPartition().getName());
        junit.framework.Assert.assertTrue((boolean)storedGroup.isEnabled());
        junit.framework.Assert.assertNull((Object)storedGroup.getExpirationDate());
        Assert.assertNotNull((Object)storedGroup.getCreatedDate());
        junit.framework.Assert.assertTrue((new Date().compareTo(storedGroup.getCreatedDate()) >= 0 ? 1 : 0) != 0);
    }

    @Test(expected=IdentityManagementException.class)
    public void testFailCreateWithSameName() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        SimpleGroup group = new SimpleGroup("group");
        identityManager.add((IdentityType)group);
        SimpleGroup groupWithSameName = new SimpleGroup("group");
        identityManager.add((IdentityType)groupWithSameName);
    }

    @Test
    public void testCreateWithSameName() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Group managerGroup = this.createGroup("managers", null);
        Group qaManagerGroup = this.createGroup("managers", "QA Group");
        Group storedManagerGroup = identityManager.getGroup(managerGroup.getPath());
        Assert.assertNotNull((Object)storedManagerGroup);
        junit.framework.Assert.assertEquals((String)managerGroup.getId(), (String)storedManagerGroup.getId());
        junit.framework.Assert.assertNull((Object)storedManagerGroup.getParentGroup());
        Group storedQAManagerGroup = identityManager.getGroup(qaManagerGroup.getPath());
        Assert.assertNotNull((Object)storedQAManagerGroup);
        junit.framework.Assert.assertEquals((String)qaManagerGroup.getId(), (String)storedQAManagerGroup.getId());
        junit.framework.Assert.assertEquals((String)qaManagerGroup.getPath(), (String)storedQAManagerGroup.getPath());
        Assert.assertFalse((boolean)storedQAManagerGroup.getId().equals(storedManagerGroup.getId()));
        Assert.assertNotNull((Object)storedQAManagerGroup.getParentGroup());
    }

    @Test
    public void testCreateWithMultipleParentGroups() {
        IdentityManager identityManager = this.getIdentityManager();
        Group groupA = this.createGroup("QA Group", null);
        Group groupB = this.createGroupWithParent("groupB", groupA);
        Group groupC = this.createGroupWithParent("groupC", groupB);
        Group groupD = this.createGroupWithParent("groupD", groupC);
        Group storedGroupD = identityManager.getGroup("/QA Group/groupB/groupC/groupD");
        Assert.assertNotNull((Object)storedGroupD);
        junit.framework.Assert.assertEquals((String)storedGroupD.getId(), (String)groupD.getId());
        Assert.assertNotNull((Object)storedGroupD.getParentGroup());
        junit.framework.Assert.assertEquals((String)storedGroupD.getParentGroup().getId(), (String)groupC.getId());
        Assert.assertNotNull((Object)storedGroupD.getParentGroup().getParentGroup());
        junit.framework.Assert.assertEquals((String)storedGroupD.getParentGroup().getParentGroup().getId(), (String)groupB.getId());
        Assert.assertNotNull((Object)storedGroupD.getParentGroup().getParentGroup().getParentGroup());
        junit.framework.Assert.assertEquals((String)storedGroupD.getParentGroup().getParentGroup().getParentGroup().getId(), (String)groupA.getId());
    }

    @Test
    public void testGetGroupPath() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Group groupA = this.createGroup("groupA", null);
        Group groupB = this.createGroupWithParent("groupB", groupA);
        Group groupC = this.createGroupWithParent("groupC", groupB);
        Group groupD = this.createGroupWithParent("groupD", groupC);
        Group storedGroupD = identityManager.getGroup("/groupA/groupB/groupC/groupD");
        junit.framework.Assert.assertEquals((String)storedGroupD.getId(), (String)groupD.getId());
        junit.framework.Assert.assertEquals((String)"/groupA/groupB/groupC/groupD", (String)storedGroupD.getPath());
        Group storedGroupB = identityManager.getGroup("/groupA/groupB");
        junit.framework.Assert.assertEquals((String)storedGroupB.getId(), (String)groupB.getId());
        junit.framework.Assert.assertEquals((String)"/groupA/groupB", (String)storedGroupB.getPath());
        Group storedGroupA = identityManager.getGroup("/groupA");
        junit.framework.Assert.assertEquals((String)storedGroupA.getId(), (String)groupA.getId());
        junit.framework.Assert.assertEquals((String)"/groupA", (String)storedGroupA.getPath());
        storedGroupA = identityManager.getGroup("groupA");
        junit.framework.Assert.assertEquals((String)storedGroupA.getId(), (String)groupA.getId());
        junit.framework.Assert.assertEquals((String)"/groupA", (String)storedGroupA.getPath());
    }

    @Test
    public void testCreateWithParentGroup() throws Exception {
        Group childGroup = this.createGroup("childGroup", "parentGroup");
        IdentityManager identityManager = this.getIdentityManager();
        Group storedChildGroup = identityManager.getGroup(childGroup.getPath());
        Assert.assertNotNull((Object)storedChildGroup);
        junit.framework.Assert.assertEquals((String)childGroup.getName(), (String)storedChildGroup.getName());
        Assert.assertNotNull((Object)storedChildGroup.getParentGroup());
        junit.framework.Assert.assertEquals((String)childGroup.getParentGroup().getId(), (String)storedChildGroup.getParentGroup().getId());
    }

    @Test
    public void testGetWithParent() throws Exception {
        Group storedGroup = this.createIdentityType();
        IdentityManager identityManager = this.getIdentityManager();
        Group parentGroup = identityManager.getGroup("Test Parent Group");
        Assert.assertNotNull((Object)parentGroup);
        Assert.assertNotNull((String)"Test Parent Group", (Object)parentGroup.getName());
        Assert.assertNotNull((String)"/Test Parent Group", (Object)parentGroup.getPath());
        storedGroup = identityManager.getGroup("Test Group", parentGroup);
        Assert.assertNotNull((Object)storedGroup);
        Assert.assertNotNull((Object)storedGroup.getParentGroup());
        junit.framework.Assert.assertEquals((String)"Test Group", (String)storedGroup.getName());
        Group invalidParentGroup = this.createGroup("invalidParentGroup", null);
        Group invalidGroup = identityManager.getGroup("Test Group", invalidParentGroup);
        junit.framework.Assert.assertNull((Object)invalidGroup);
    }

    @Test
    public void testRemove() throws Exception {
        Group storedGroup = this.createIdentityType();
        Assert.assertNotNull((Object)storedGroup);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.remove((IdentityType)storedGroup);
        Group removedGroup = identityManager.getGroup(storedGroup.getName());
        junit.framework.Assert.assertNull((Object)removedGroup);
        User anotherUser = this.createUser("user");
        Role role = this.createRole("role");
        Group group = this.createGroup("group", null);
        identityManager.addToGroup((Agent)anotherUser, group);
        identityManager.grantGroupRole((IdentityType)anotherUser, role, group);
        RelationshipQuery relationshipQuery = identityManager.createRelationshipQuery(GroupMembership.class);
        relationshipQuery.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{group});
        Assert.assertFalse((boolean)relationshipQuery.getResultList().isEmpty());
        relationshipQuery = identityManager.createRelationshipQuery(GroupRole.class);
        relationshipQuery.setParameter((QueryParameter)GroupRole.GROUP, new Object[]{group});
        Assert.assertFalse((boolean)relationshipQuery.getResultList().isEmpty());
        identityManager.remove((IdentityType)group);
        relationshipQuery = identityManager.createRelationshipQuery(GroupMembership.class);
        relationshipQuery.setParameter((QueryParameter)GroupMembership.GROUP, new Object[]{group});
        junit.framework.Assert.assertTrue((boolean)relationshipQuery.getResultList().isEmpty());
        relationshipQuery = identityManager.createRelationshipQuery(GroupRole.class);
        relationshipQuery.setParameter((QueryParameter)GroupRole.GROUP, new Object[]{group});
        junit.framework.Assert.assertTrue((boolean)relationshipQuery.getResultList().isEmpty());
    }

    @Override
    protected Group createIdentityType() {
        return this.createGroup("Test Group", "Test Parent Group");
    }

    @Override
    protected Group getIdentityType() {
        return this.getIdentityManager().getGroup("Test Group", this.getGroup("Test Parent Group"));
    }

    @Test
    public void testEqualsMethod() {
        Group instanceA = this.createGroup("groupA");
        Group instanceB = this.createGroup("groupB");
        Assert.assertFalse((boolean)instanceA.equals(instanceB));
        IdentityManager identityManager = this.getIdentityManager();
        junit.framework.Assert.assertTrue((boolean)instanceA.equals(identityManager.getGroup(instanceA.getPath())));
    }
}

