/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.basic;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.test.idm.basic.AbstractIdentityTypeTestCase;

public class RoleManagementTestCase
extends AbstractIdentityTypeTestCase<Role> {
    @Test
    public void testCreate() throws Exception {
        Role newRole = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        Role storedRole = identityManager.getRole(newRole.getName());
        Assert.assertNotNull((Object)storedRole);
        junit.framework.Assert.assertEquals((String)newRole.getId(), (String)storedRole.getId());
        junit.framework.Assert.assertEquals((String)newRole.getName(), (String)storedRole.getName());
        Assert.assertNotNull((Object)storedRole.getPartition());
        junit.framework.Assert.assertEquals((String)"default", (String)storedRole.getPartition().getName());
        junit.framework.Assert.assertTrue((boolean)storedRole.isEnabled());
        junit.framework.Assert.assertNull((Object)storedRole.getExpirationDate());
        Assert.assertNotNull((Object)storedRole.getCreatedDate());
        junit.framework.Assert.assertTrue((new Date().compareTo(storedRole.getCreatedDate()) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() throws Exception {
        Role storedRole = this.createIdentityType();
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.remove((IdentityType)storedRole);
        Role removedRole = identityManager.getRole(storedRole.getName());
        junit.framework.Assert.assertNull((Object)removedRole);
        User anotherUser = this.createUser("user");
        Role role = this.createRole("role");
        Group group = this.createGroup("group", null);
        identityManager.grantRole((IdentityType)anotherUser, role);
        identityManager.addToGroup((Agent)anotherUser, group);
        identityManager.grantGroupRole((IdentityType)anotherUser, role, group);
        RelationshipQuery relationshipQuery = identityManager.createRelationshipQuery(Grant.class);
        relationshipQuery.setParameter((QueryParameter)Grant.ROLE, new Object[]{role});
        Assert.assertFalse((boolean)relationshipQuery.getResultList().isEmpty());
        relationshipQuery = identityManager.createRelationshipQuery(GroupRole.class);
        relationshipQuery.setParameter((QueryParameter)GroupRole.ROLE, new Object[]{role});
        Assert.assertFalse((boolean)relationshipQuery.getResultList().isEmpty());
        identityManager.remove((IdentityType)role);
        relationshipQuery = identityManager.createRelationshipQuery(Grant.class);
        relationshipQuery.setParameter((QueryParameter)Grant.ROLE, new Object[]{role});
        junit.framework.Assert.assertTrue((boolean)relationshipQuery.getResultList().isEmpty());
        relationshipQuery = identityManager.createRelationshipQuery(GroupRole.class);
        relationshipQuery.setParameter((QueryParameter)GroupRole.ROLE, new Object[]{role});
        junit.framework.Assert.assertTrue((boolean)relationshipQuery.getResultList().isEmpty());
    }

    @Test
    public void testEqualsMethod() {
        Role instanceA = this.createRole("roleA");
        Role instanceB = this.createRole("roleB");
        Assert.assertFalse((boolean)instanceA.equals(instanceB));
        IdentityManager identityManager = this.getIdentityManager();
        junit.framework.Assert.assertTrue((boolean)instanceA.equals(identityManager.getRole(instanceA.getName())));
    }

    @Override
    protected Role createIdentityType() {
        return this.createRole("Administrator");
    }

    @Override
    protected Role getIdentityType() {
        return this.getIdentityManager().getRole("Administrator");
    }
}

