/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.test.idm.relationship.CustomRelationship;

public abstract class AbstractFeaturesSetConfigurationTestCase<T extends IdentityStoreConfiguration> {
    @Test
    public void failFeatureNotSupportedUserRead() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.user, FeatureSet.FeatureOperation.read);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.getUser("someUser");
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[user.read]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedUserCreate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.user, FeatureSet.FeatureOperation.create);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.add((IdentityType)new SimpleUser("someUser"));
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[user.create]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedUserDelete() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.user, FeatureSet.FeatureOperation.delete);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            SimpleUser user = new SimpleUser("someUser");
            identityManager.add((IdentityType)user);
            identityManager.remove((IdentityType)user);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[user.delete]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRoleRead() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.role, FeatureSet.FeatureOperation.read);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.getRole("someRole");
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[role.read]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRoleCreate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.role, FeatureSet.FeatureOperation.create);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.add((IdentityType)new SimpleRole("someRole"));
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[role.create]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRoleDelete() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.role, FeatureSet.FeatureOperation.delete);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            SimpleRole role = new SimpleRole("someRole");
            identityManager.add((IdentityType)role);
            identityManager.remove((IdentityType)role);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[role.delete]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedGroupRead() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.group, FeatureSet.FeatureOperation.read);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.getGroup("someGroup");
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[group.read]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedGroupCreate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.group, FeatureSet.FeatureOperation.create);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.add((IdentityType)new SimpleGroup("someGroup"));
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[group.create]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedGroupDelete() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.group, FeatureSet.FeatureOperation.delete);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            SimpleGroup role = new SimpleGroup("someGroup");
            identityManager.add((IdentityType)role);
            identityManager.remove((IdentityType)role);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[group.delete]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRelationshipRead() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.read);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.createRelationshipQuery(Relationship.class);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[relationship.read]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRelationshipCreate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.create);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            SimpleUser user = new SimpleUser();
            identityManager.add((IdentityType)user);
            SimpleRole role = new SimpleRole("someRole");
            identityManager.add((IdentityType)role);
            identityManager.add((Relationship)new Grant((IdentityType)user, (Role)role));
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[relationship.create]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedCustomRelationship() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().setSupportsCustomRelationships(false);
        config.addStoreConfiguration(storeConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        SimpleUser user = new SimpleUser();
        identityManager.add((IdentityType)user);
        SimpleRole role = new SimpleRole("someRole");
        identityManager.add((IdentityType)role);
        CustomRelationship customRelationship = new CustomRelationship();
        customRelationship.setIdentityTypeA((IdentityType)user);
        customRelationship.setIdentityTypeB((IdentityType)role);
        try {
            identityManager.add((Relationship)customRelationship);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().contains("[" + CustomRelationship.class.getName() + "]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
        config = new IdentityConfiguration();
        storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet();
        FeatureSet.removeRelationshipSupport((FeatureSet)storeConfig.getFeatureSet(), (Class[])new Class[]{CustomRelationship.class});
        config.addStoreConfiguration(storeConfig);
        identityManager = this.createIdentityManager(config);
        try {
            identityManager.add((Relationship)customRelationship);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().contains("[relationship.create]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRelationshipDelete() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.delete);
        config.addStoreConfiguration(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            SimpleUser user = new SimpleUser();
            identityManager.add((IdentityType)user);
            SimpleRole role = new SimpleRole("someRole");
            identityManager.add((IdentityType)role);
            Grant grant = new Grant((IdentityType)user, (Role)role);
            identityManager.add((Relationship)grant);
            identityManager.remove((Relationship)grant);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[relationship.delete]"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedCredentialUpdate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.credential, FeatureSet.FeatureOperation.update);
        config.addStoreConfiguration(storeConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        SimpleUser user = new SimpleUser();
        identityManager.add((IdentityType)user);
        Password password = new Password("123");
        try {
            identityManager.updateCredential((Agent)user, (Object)password);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[credential.update]"));
        }
    }

    @Test
    public void failFeatureNotSupportedCredentialValidate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.credential, FeatureSet.FeatureOperation.validate);
        config.addStoreConfiguration(storeConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        SimpleUser user = new SimpleUser();
        identityManager.add((IdentityType)user);
        Password password = new Password("123");
        identityManager.updateCredential((Agent)user, (Object)password);
        try {
            identityManager.validateCredentials((Credentials)new UsernamePasswordCredentials(user.getLoginName(), password));
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[credential.validate]"));
        }
    }

    protected abstract T createMinimalConfiguration();

    protected abstract IdentityManager createIdentityManager(IdentityConfiguration var1);
}

