/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import java.io.InputStream;
import javax.naming.CommunicationException;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.config.idm.XMLBasedIdentityManagerProvider;
import org.picketlink.idm.IdentityManager;

public class XMLIdentityManagerProviderTestCase {
    @Test
    public void testParseLdapConfiguration() {
        try {
            IdentityManager identityManager = this.createIdentityConfiguration("config/embedded-ldap-config.xml");
            Assert.fail((String)"expected exception thrown");
        }
        catch (RuntimeException re) {
            Assert.assertNotNull((Object)re.getCause());
            Assert.assertEquals(CommunicationException.class, re.getCause().getClass());
            Assert.assertTrue((boolean)re.getCause().getMessage().contains("localhost:10389"));
        }
    }

    @Test
    public void testParseFileConfiguration() {
        IdentityManager identityManager = this.createIdentityConfiguration("config/embedded-file-config.xml");
        Assert.assertNotNull((Object)identityManager);
    }

    @Test
    public void testParseJpaConfiguration() {
        try {
            IdentityManager identityManager = this.createIdentityConfiguration("config/embedded-jpa-config.xml");
            Assert.fail((String)"expected exception thrown");
        }
        catch (RuntimeException re) {
            Assert.assertNotNull((Object)re.getCause());
            Assert.assertEquals(ClassNotFoundException.class, re.getCause().getClass());
        }
    }

    private IdentityManager createIdentityConfiguration(String identityConfigFile) {
        XMLBasedIdentityManagerProvider configProvider = new XMLBasedIdentityManagerProvider();
        InputStream configStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(identityConfigFile);
        return configProvider.buildIdentityManager(configStream);
    }
}

