/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.partition;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class RealmManagementTestCase
extends AbstractIdentityManagerTestCase {
    private static final String TESTING_REALM_NAME = "Testing";

    @Test
    public void testCreate() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        realm = defaultIdentityManager.getRealm(realm.getName());
        Assert.assertNotNull((Object)realm);
        Assert.assertEquals((Object)TESTING_REALM_NAME, (Object)realm.getName());
        Assert.assertEquals((Object)"REALM://Testing", (Object)realm.getKey());
    }

    @Test
    public void testGetDefaultRealm() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        Realm defaultRealm = defaultIdentityManager.getRealm("default");
        Assert.assertNotNull((Object)defaultRealm);
        Assert.assertEquals((Object)"default", (Object)defaultRealm.getName());
    }

    @Test(expected=IdentityManagementException.class)
    public void testCreateWithNullArgument() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        defaultIdentityManager.createRealm(null);
    }

    @Test(expected=InstantiationError.class)
    public void testCreateWithNullName() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        defaultIdentityManager.createRealm(new Realm(null));
    }

    @Test
    public void testRemove() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        defaultIdentityManager.removeRealm(realm);
        realm = defaultIdentityManager.getRealm(realm.getName());
        Assert.assertNull((Object)realm);
    }

    @Test(expected=IdentityManagementException.class)
    public void testRemoveWithUsers() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        IdentityManager testingIdentityManager = defaultIdentityManager.forRealm(realm);
        SimpleUser testingUser = new SimpleUser("testingUser");
        testingIdentityManager.add((IdentityType)testingUser);
        defaultIdentityManager.removeRealm(realm);
    }

    @Test(expected=IdentityManagementException.class)
    public void testRemoveWithRoles() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        IdentityManager testingIdentityManager = defaultIdentityManager.forRealm(realm);
        SimpleRole testingRole = new SimpleRole("testingRole");
        testingIdentityManager.add((IdentityType)testingRole);
        defaultIdentityManager.removeRealm(realm);
    }

    @Test(expected=IdentityManagementException.class)
    public void testRemoveWithGroups() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        IdentityManager testingIdentityManager = defaultIdentityManager.forRealm(realm);
        SimpleGroup testingGroup = new SimpleGroup("testingGroup");
        testingIdentityManager.add((IdentityType)testingGroup);
        defaultIdentityManager.removeRealm(realm);
    }

    @Test
    public void testCreateUsers() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleUser realmUser = new SimpleUser("realmUser");
        defaultIdentityManager.forRealm(realm).add((IdentityType)realmUser);
        realmUser = defaultIdentityManager.forRealm(realm).getUser(realmUser.getLoginName());
        Assert.assertNotNull((Object)realmUser);
        Assert.assertNotNull((Object)realmUser.getPartition());
        Assert.assertEquals((Object)realm.getId(), (Object)realmUser.getPartition().getId());
        realmUser = defaultIdentityManager.getUser(realmUser.getLoginName());
        Assert.assertNull((Object)realmUser);
    }

    @Test
    public void testCreateSameUserDifferentRealms() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleUser defaultRealmUser = new SimpleUser("commonName");
        defaultIdentityManager.add((IdentityType)defaultRealmUser);
        try {
            defaultIdentityManager.add((IdentityType)new SimpleUser(defaultRealmUser.getLoginName()));
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        Realm realm = this.createRealm();
        SimpleUser testingRealmUser = new SimpleUser("commonName");
        IdentityManager testingRealmManager = defaultIdentityManager.forRealm(realm);
        testingRealmManager.add((IdentityType)testingRealmUser);
        defaultRealmUser = defaultIdentityManager.getUser(defaultRealmUser.getLoginName());
        Assert.assertNotNull((Object)defaultRealmUser);
        testingRealmUser = testingRealmManager.getUser(testingRealmUser.getLoginName());
        Assert.assertNotNull((Object)testingRealmUser);
        Assert.assertFalse((boolean)defaultRealmUser.getId().equals(testingRealmUser.getId()));
    }

    @Test
    public void testCreateSameRoleDifferentRealms() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleRole defaultRealmRole = new SimpleRole("commonName");
        defaultIdentityManager.add((IdentityType)defaultRealmRole);
        try {
            defaultIdentityManager.add((IdentityType)new SimpleRole(defaultRealmRole.getName()));
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        Realm realm = this.createRealm();
        SimpleRole testingRealmRole = new SimpleRole("commonName");
        IdentityManager testingRealmManager = defaultIdentityManager.forRealm(realm);
        testingRealmManager.add((IdentityType)testingRealmRole);
        defaultRealmRole = defaultIdentityManager.getRole(defaultRealmRole.getName());
        Assert.assertNotNull((Object)defaultRealmRole);
        testingRealmRole = testingRealmManager.getRole(testingRealmRole.getName());
        Assert.assertNotNull((Object)testingRealmRole);
        Assert.assertFalse((boolean)defaultRealmRole.getId().equals(testingRealmRole.getId()));
    }

    @Test
    public void testCreateSameGroupDifferentRealms() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleGroup defaultRealmGroup = new SimpleGroup("commonName");
        defaultIdentityManager.add((IdentityType)defaultRealmGroup);
        try {
            defaultIdentityManager.add((IdentityType)new SimpleGroup(defaultRealmGroup.getName()));
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        Realm realm = this.createRealm();
        SimpleGroup testingRealmGroup = new SimpleGroup("commonName");
        IdentityManager testingRealmManager = defaultIdentityManager.forRealm(realm);
        testingRealmManager.add((IdentityType)testingRealmGroup);
        defaultRealmGroup = defaultIdentityManager.getGroup(defaultRealmGroup.getName());
        Assert.assertNotNull((Object)defaultRealmGroup);
        testingRealmGroup = testingRealmManager.getGroup(testingRealmGroup.getName());
        Assert.assertNotNull((Object)testingRealmGroup);
        Assert.assertFalse((boolean)defaultRealmGroup.getId().equals(testingRealmGroup.getId()));
    }

    @Test
    public void testCreateRoles() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleRole testingRole = new SimpleRole("testingRole");
        defaultIdentityManager.forRealm(realm).add((IdentityType)testingRole);
        testingRole = defaultIdentityManager.forRealm(realm).getRole(testingRole.getName());
        Assert.assertNotNull((Object)testingRole);
        Assert.assertNotNull((Object)testingRole.getPartition());
        Assert.assertEquals((Object)realm.getId(), (Object)testingRole.getPartition().getId());
        testingRole = defaultIdentityManager.getRole(testingRole.getName());
        Assert.assertNull((Object)testingRole);
    }

    @Test
    public void testCreateGroups() throws Exception {
        Realm realm = this.createRealm();
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleGroup testingGroup = new SimpleGroup("testingRealmGroup");
        defaultIdentityManager.forRealm(realm).add((IdentityType)testingGroup);
        testingGroup = defaultIdentityManager.forRealm(realm).getGroup(testingGroup.getName());
        Assert.assertNotNull((Object)testingGroup);
        Assert.assertNotNull((Object)testingGroup.getPartition());
        Assert.assertEquals((Object)realm.getId(), (Object)testingGroup.getPartition().getId());
        testingGroup = defaultIdentityManager.getGroup(testingGroup.getName());
        Assert.assertNull((Object)testingGroup);
    }

    @Test
    public void testRelationships() throws Exception {
        IdentityManager defaultIdentityManager = this.getIdentityManager();
        SimpleUser defaultRealmUser = new SimpleUser("defaultRealmUser");
        SimpleRole defaultRealmRole = new SimpleRole("defaultRealmRole");
        SimpleGroup defaultRealmGroup = new SimpleGroup("defaultRealmGroup");
        defaultIdentityManager.add((IdentityType)defaultRealmUser);
        defaultIdentityManager.add((IdentityType)defaultRealmRole);
        defaultIdentityManager.add((IdentityType)defaultRealmGroup);
        defaultIdentityManager.grantRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole);
        defaultIdentityManager.addToGroup((Agent)defaultRealmUser, (Group)defaultRealmGroup);
        defaultIdentityManager.grantGroupRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole, (Group)defaultRealmGroup);
        Assert.assertTrue((boolean)defaultIdentityManager.hasRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole));
        Assert.assertTrue((boolean)defaultIdentityManager.isMember((IdentityType)defaultRealmUser, (Group)defaultRealmGroup));
        Assert.assertTrue((boolean)defaultIdentityManager.hasGroupRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole, (Group)defaultRealmGroup));
        Realm realm = this.createRealm();
        IdentityManager testingRealmManager = defaultIdentityManager.forRealm(realm);
        Assert.assertFalse((boolean)testingRealmManager.hasRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole));
        Assert.assertFalse((boolean)testingRealmManager.isMember((IdentityType)defaultRealmUser, (Group)defaultRealmGroup));
        Assert.assertFalse((boolean)testingRealmManager.hasGroupRole((IdentityType)defaultRealmUser, (Role)defaultRealmRole, (Group)defaultRealmGroup));
        SimpleUser testingRealmUser = new SimpleUser("testingRealmUser");
        SimpleRole testingRealmRole = new SimpleRole("testingRealmRole");
        SimpleGroup testingRealmGroup = new SimpleGroup("testingRealmGroup");
        testingRealmManager.add((IdentityType)testingRealmUser);
        testingRealmManager.add((IdentityType)testingRealmRole);
        testingRealmManager.add((IdentityType)testingRealmGroup);
        testingRealmManager.grantRole((IdentityType)testingRealmUser, (Role)testingRealmRole);
        testingRealmManager.addToGroup((Agent)testingRealmUser, (Group)testingRealmGroup);
        testingRealmManager.grantGroupRole((IdentityType)testingRealmUser, (Role)testingRealmRole, (Group)testingRealmGroup);
        Assert.assertTrue((boolean)testingRealmManager.hasRole((IdentityType)testingRealmUser, (Role)testingRealmRole));
        Assert.assertTrue((boolean)testingRealmManager.isMember((IdentityType)testingRealmUser, (Group)testingRealmGroup));
        Assert.assertTrue((boolean)testingRealmManager.hasGroupRole((IdentityType)testingRealmUser, (Role)testingRealmRole, (Group)testingRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.hasRole((IdentityType)testingRealmUser, (Role)testingRealmRole));
        Assert.assertFalse((boolean)defaultIdentityManager.isMember((IdentityType)testingRealmUser, (Group)testingRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.hasGroupRole((IdentityType)testingRealmUser, (Role)testingRealmRole, (Group)testingRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.hasRole((IdentityType)defaultRealmUser, (Role)testingRealmRole));
        Assert.assertFalse((boolean)defaultIdentityManager.hasRole((IdentityType)testingRealmUser, (Role)defaultRealmRole));
        Assert.assertFalse((boolean)defaultIdentityManager.isMember((IdentityType)defaultRealmUser, (Group)testingRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.isMember((IdentityType)testingRealmUser, (Group)defaultRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.hasGroupRole((IdentityType)defaultRealmUser, (Role)testingRealmRole, (Group)defaultRealmGroup));
        Assert.assertFalse((boolean)defaultIdentityManager.hasGroupRole((IdentityType)testingRealmUser, (Role)defaultRealmRole, (Group)testingRealmGroup));
    }

    private Realm createRealm() {
        IdentityManager identityManager = this.getIdentityManager();
        Realm realm = identityManager.getRealm(TESTING_REALM_NAME);
        if (realm == null) {
            realm = new Realm(TESTING_REALM_NAME);
            identityManager.createRealm(realm);
        }
        return realm;
    }
}

