/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.ExcludeTestSuite;
import org.picketlink.test.idm.query.AbstractIdentityQueryTestCase;
import org.picketlink.test.idm.suites.LDAPIdentityStoreTestSuite;
import org.picketlink.test.idm.suites.LDAPJPAMixedStoreTestSuite;

public class AgentQueryTestCase<T extends Agent>
extends AbstractIdentityQueryTestCase<T> {
    @Override
    protected T createIdentityType(String name, Partition partition) {
        if (name == null) {
            name = "someSimpleAgent";
        }
        return (T)this.createAgent(name, partition);
    }

    @Override
    protected T getIdentityType() {
        return (T)this.getIdentityManager().getAgent("someSimpleAgent");
    }

    @After
    public void onFinish() {
        T agentType = this.createIdentityType(null, null);
        IdentityQuery query = this.getIdentityManager().createIdentityQuery(agentType.getClass());
        List result = query.getResultList();
        for (Agent agent : result) {
            this.getIdentityManager().remove((IdentityType)agent);
        }
    }

    @Test
    public void testFindByLoginName() throws Exception {
        T agentType = this.createIdentityType(null, null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(Agent.LOGIN_NAME, new Object[]{agentType.getLoginName()});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertEquals((String)agentType.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindByMultipleAgentWithGroups() throws Exception {
        T agentType = this.createIdentityType("admin", null);
        T someAgent = this.createIdentityType("someAgent", null);
        Group administratorGroup = this.createGroup("Administrators", null);
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup(agentType, administratorGroup);
        identityManager.addToGroup(someAgent, administratorGroup);
        IdentityQuery query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(Agent.MEMBER_OF, new Object[]{administratorGroup});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)2, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, agentType.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        identityManager.addToGroup(agentType, someGroup);
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(Agent.MEMBER_OF, new Object[]{administratorGroup, someGroup});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, agentType.getId()));
    }

    @Test
    public void testFindByMultipleAgentWithRoles() throws Exception {
        T agentType = this.createIdentityType("admin", null);
        T someAgent = this.createIdentityType("someAgent", null);
        Role administratorRole = this.createRole("Administrators");
        Role someRole = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole(agentType, administratorRole);
        identityManager.grantRole(someAgent, administratorRole);
        IdentityQuery query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(Agent.HAS_ROLE, new Object[]{administratorRole});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)2, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, agentType.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        identityManager.grantRole(agentType, someRole);
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(Agent.HAS_ROLE, new Object[]{administratorRole, someRole});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertTrue((boolean)this.contains(result, agentType.getId()));
    }

    @Test
    public void testFindBySingleGroupRole() throws Exception {
        T agentType = this.createIdentityType("someUser", null);
        Group salesGroup = this.createGroup("Sales", null);
        Role managerRole = this.createRole("Manager");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.HAS_GROUP_ROLE, new Object[]{new GroupRole(agentType, salesGroup, managerRole)});
        List result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        identityManager.grantGroupRole(agentType, managerRole, salesGroup);
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.HAS_GROUP_ROLE, new Object[]{new GroupRole(agentType, salesGroup, managerRole)});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)agentType.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindBySingleGroup() throws Exception {
        T agentType = this.createIdentityType("admin", null);
        Group administratorGroup = this.createGroup("Administrators", null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup});
        List result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        identityManager.addToGroup(agentType, administratorGroup);
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)agentType.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindBySingleRole() throws Exception {
        T agentType = this.createIdentityType("admin", null);
        Role administratorRole = this.createRole("Administrators");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole});
        List result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        identityManager.grantRole(agentType, administratorRole);
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)agentType.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindByMultipleGroups() throws Exception {
        T agentType = this.createIdentityType("admin", null);
        Group administratorGroup = this.createGroup("Administrators", null);
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup(agentType, administratorGroup);
        identityManager.addToGroup(agentType, someGroup);
        IdentityQuery query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup, someGroup});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)agentType.getId(), (String)((Agent)result.get(0)).getId());
        identityManager.removeFromGroup(agentType, someGroup);
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup, someGroup});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)agentType.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindByMultipleRoles() throws Exception {
        T agentType = this.createIdentityType("admin", null);
        Role administratorRole = this.createRole("Administrators");
        Role someRole = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole(agentType, administratorRole);
        identityManager.grantRole(agentType, someRole);
        IdentityQuery query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)agentType.getId(), (String)((Agent)result.get(0)).getId());
        identityManager.revokeRole(agentType, someRole);
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole, someRole});
        result = query.getResultList();
        Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((String)agentType.getId(), (String)((Agent)result.get(0)).getId());
    }

    @Test
    public void testFindByMultipleUserWithGroups() throws Exception {
        T agentType = this.createIdentityType("admin", null);
        T someAgent = this.createIdentityType("someUser", null);
        Group administratorGroup = this.createGroup("Administrators", null);
        Group someGroup = this.createGroup("someGroup", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup(agentType, administratorGroup);
        identityManager.addToGroup(someAgent, administratorGroup);
        IdentityQuery query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, agentType.getId()));
        Assert.assertTrue((boolean)this.contains(result, someAgent.getId()));
        identityManager.addToGroup(agentType, someGroup);
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.MEMBER_OF, new Object[]{administratorGroup, someGroup});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, agentType.getId()));
        Assert.assertFalse((boolean)this.contains(result, someAgent.getId()));
    }

    @Test
    public void testFindByMultipleUserWithRoles() throws Exception {
        T agentType = this.createIdentityType("admin", null);
        T someagent = this.createIdentityType("someUser", null);
        Role administratorRole = this.createRole("Administrators");
        Role someRole = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole(agentType, administratorRole);
        identityManager.grantRole(someagent, administratorRole);
        IdentityQuery query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, agentType.getId()));
        Assert.assertTrue((boolean)this.contains(result, someagent.getId()));
        identityManager.grantRole(agentType, someRole);
        query = identityManager.createIdentityQuery(agentType.getClass());
        query.setParameter(User.HAS_ROLE, new Object[]{administratorRole, someRole});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, agentType.getId()));
        Assert.assertFalse((boolean)this.contains(result, someagent.getId()));
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPJPAMixedStoreTestSuite.class})
    public void testFindByLoginNameAndCreationDateWithSorting() throws Exception {
        this.createAgent("john");
        IDMUtil.sleep((int)1);
        this.createAgent("demo");
        IDMUtil.sleep((int)1);
        this.createAgent("root");
        IDMUtil.sleep((int)1);
        Agent mary = this.createAgent("mary");
        mary.setEnabled(false);
        this.getIdentityManager().update((IdentityType)mary);
        IdentityQuery agentQuery = this.getIdentityManager().createIdentityQuery(Agent.class);
        List agents = agentQuery.getResultList();
        Assert.assertEquals((int)4, (int)agents.size());
        Assert.assertEquals((String)((Agent)agents.get(0)).getLoginName(), (String)"demo");
        Assert.assertEquals((String)((Agent)agents.get(1)).getLoginName(), (String)"john");
        Assert.assertEquals((String)((Agent)agents.get(2)).getLoginName(), (String)"mary");
        Assert.assertEquals((String)((Agent)agents.get(3)).getLoginName(), (String)"root");
        agentQuery = this.getIdentityManager().createIdentityQuery(Agent.class);
        agentQuery.setSortAscending(false);
        agentQuery.setSortParameters(new QueryParameter[]{IdentityType.ENABLED, IdentityType.CREATED_DATE});
        agents = agentQuery.getResultList();
        Assert.assertEquals((int)4, (int)agents.size());
        Assert.assertEquals((String)((Agent)agents.get(0)).getLoginName(), (String)"root");
        Assert.assertEquals((String)((Agent)agents.get(1)).getLoginName(), (String)"demo");
        Assert.assertEquals((String)((Agent)agents.get(2)).getLoginName(), (String)"john");
        Assert.assertEquals((String)((Agent)agents.get(3)).getLoginName(), (String)"mary");
    }
}

