/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.ExcludeTestSuite;
import org.picketlink.test.idm.query.AbstractIdentityQueryTestCase;
import org.picketlink.test.idm.suites.LDAPIdentityStoreTestSuite;
import org.picketlink.test.idm.suites.LDAPJPAMixedStoreTestSuite;

public class RoleQueryTestCase
extends AbstractIdentityQueryTestCase<Role> {
    @Override
    protected Role createIdentityType(String name, Partition partition) {
        if (name == null) {
            name = "someRole";
        }
        return this.createRole(name, partition);
    }

    @Override
    protected Role getIdentityType() {
        return this.getIdentityManager().getRole("someRole");
    }

    @After
    public void onFinish() {
        IdentityQuery query = this.getIdentityManager().createIdentityQuery(Role.class);
        List result = query.getResultList();
        for (Role role : result) {
            this.getIdentityManager().remove((IdentityType)role);
        }
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPJPAMixedStoreTestSuite.class})
    public void testFindByTier() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Tier someTier = new Tier("Some Role Tier");
        identityManager.createTier(someTier);
        SimpleRole someRoleRealm = new SimpleRole("someRoleRealm");
        identityManager.forTier(someTier).add((IdentityType)someRoleRealm);
        IdentityQuery query = identityManager.forTier(someTier).createIdentityQuery(Role.class);
        Assert.assertNotNull((Object)someTier);
        query.setParameter(Role.PARTITION, new Object[]{someTier});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRoleRealm.getId()));
        Tier someAnotherTier = new Tier("Some Another Role Tier");
        identityManager.createTier(someAnotherTier);
        SimpleRole someRoleTestingTier = new SimpleRole("someRoleTestingRealm");
        identityManager.forTier(someAnotherTier).add((IdentityType)someRoleTestingTier);
        query = identityManager.forTier(someAnotherTier).createIdentityQuery(Role.class);
        query.setParameter(Role.PARTITION, new Object[]{someAnotherTier});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRoleTestingTier.getId()));
    }

    @Test
    public void testFindByName() throws Exception {
        Role role = this.createRole("admin");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.NAME, new Object[]{"admin"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)role.getId(), (String)((Role)result.get(0)).getId());
    }

    @Test
    public void testFindUserRoles() throws Exception {
        Role someRole = this.createRole("someRole");
        Role someAnotherRole = this.createRole("someAnotherRole");
        Role someImportantRole = this.createRole("someImportantRole");
        User user = this.createUser("someUser");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someRole.getId()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someAnotherRole.getId()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someImportantRole.getId()));
        identityManager.grantRole((IdentityType)user, someRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getId()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someAnotherRole.getId()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someImportantRole.getId()));
        identityManager.grantRole((IdentityType)user, someAnotherRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getId()));
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someImportantRole.getId()));
        identityManager.grantRole((IdentityType)user, someImportantRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someRole.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someImportantRole.getId()));
        identityManager.revokeRole((IdentityType)user, someRole);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertFalse((boolean)this.contains(result, someRole.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherRole.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someImportantRole.getId()));
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPJPAMixedStoreTestSuite.class})
    public void testFindWithSorting() throws Exception {
        this.createRole("someRole");
        this.createRole("someAnotherRole");
        this.createRole("someImportantRole");
        IdentityQuery roleQuery = this.getIdentityManager().createIdentityQuery(Role.class);
        roleQuery.setSortAscending(false);
        List roles = roleQuery.getResultList();
        junit.framework.Assert.assertEquals((int)3, (int)roles.size());
        junit.framework.Assert.assertEquals((String)((Role)roles.get(0)).getName(), (String)"someRole");
        junit.framework.Assert.assertEquals((String)((Role)roles.get(1)).getName(), (String)"someImportantRole");
        junit.framework.Assert.assertEquals((String)((Role)roles.get(2)).getName(), (String)"someAnotherRole");
    }
}

