/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.relationship;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Role;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class AgentGroupRoleRelationshipTestCase<T extends Agent>
extends AbstractIdentityManagerTestCase {
    protected T createIdentityType(String name, Partition partition) {
        if (name == null) {
            name = "someAgent";
        }
        return (T)this.createAgent(name, partition);
    }

    protected T getIdentityType() {
        return (T)this.getIdentityManager().getAgent("someAgent");
    }

    @Test
    public void testGrantGroupRole() throws Exception {
        T developerAgent = this.createIdentityType("developerAgent", null);
        T projectManagerAgent = this.createIdentityType("projectManagerAgent", null);
        Role managerRole = this.createRole("Manager");
        Role developerRole = this.createRole("Developer");
        Role employeeRole = this.createRole("Employee");
        Group companyGroup = this.createGroup("Company Group", null);
        Group projectGroup = this.createGroup("Project Group", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantGroupRole(developerAgent, employeeRole, companyGroup);
        identityManager.grantGroupRole(developerAgent, developerRole, projectGroup);
        identityManager.grantGroupRole(projectManagerAgent, employeeRole, companyGroup);
        identityManager.grantGroupRole(projectManagerAgent, managerRole, projectGroup);
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(developerAgent, employeeRole, companyGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(developerAgent, developerRole, projectGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(projectManagerAgent, employeeRole, companyGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(projectManagerAgent, managerRole, projectGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole(developerAgent, managerRole, projectGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole(projectManagerAgent, developerRole, projectGroup));
        Assert.assertFalse((boolean)identityManager.isMember(developerAgent, projectGroup));
        Assert.assertFalse((boolean)identityManager.isMember(developerAgent, companyGroup));
        Assert.assertFalse((boolean)identityManager.hasRole(developerAgent, employeeRole));
    }

    @Test
    public void testGrantParentGroupRole() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Group administratorsGroup = this.createGroup("Administrators", null);
        Group systemAdministradorsGroup = this.createGroupWithParent("System Administrators", administratorsGroup);
        Group databaseAdministratorsGroup = this.createGroupWithParent("Database Administrators", systemAdministradorsGroup);
        Role managerRole = this.createRole("Administrators Manager");
        T agent = this.createIdentityType("agent", null);
        identityManager.grantGroupRole(agent, managerRole, administratorsGroup);
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(agent, managerRole, administratorsGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(agent, managerRole, databaseAdministratorsGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(agent, managerRole, systemAdministradorsGroup));
        Role securityManager = this.createRole("Data Security Manager");
        identityManager.grantGroupRole(agent, securityManager, databaseAdministratorsGroup);
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(agent, securityManager, databaseAdministratorsGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole(agent, securityManager, administratorsGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole(agent, securityManager, systemAdministradorsGroup));
        identityManager.revokeGroupRole(agent, managerRole, administratorsGroup);
        Assert.assertFalse((boolean)identityManager.hasGroupRole(agent, managerRole, administratorsGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole(agent, managerRole, databaseAdministratorsGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole(agent, managerRole, systemAdministradorsGroup));
        identityManager.grantGroupRole(agent, managerRole, systemAdministradorsGroup);
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(agent, managerRole, databaseAdministratorsGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(agent, managerRole, systemAdministradorsGroup));
        Assert.assertFalse((boolean)identityManager.hasGroupRole(agent, managerRole, administratorsGroup));
    }

    @Test
    public void testRevokeGroupRole() throws Exception {
        T developerAgent = this.createIdentityType("developerAgent", null);
        Role developerRole = this.createRole("Developer");
        Role employeeRole = this.createRole("Employee");
        Group companyGroup = this.createGroup("Company Group", null);
        Group projectGroup = this.createGroup("Project Group", null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantGroupRole(developerAgent, employeeRole, companyGroup);
        identityManager.grantGroupRole(developerAgent, developerRole, projectGroup);
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(developerAgent, employeeRole, companyGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(developerAgent, developerRole, projectGroup));
        identityManager.revokeGroupRole(developerAgent, developerRole, projectGroup);
        Assert.assertFalse((boolean)identityManager.hasGroupRole(developerAgent, developerRole, projectGroup));
        junit.framework.Assert.assertTrue((boolean)identityManager.hasGroupRole(developerAgent, employeeRole, companyGroup));
        identityManager.revokeGroupRole(developerAgent, employeeRole, companyGroup);
        Assert.assertFalse((boolean)identityManager.hasGroupRole(developerAgent, employeeRole, companyGroup));
    }
}

