/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.suites;

import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.file.internal.FileDataSource;
import org.picketlink.idm.file.internal.FileIdentityStoreConfiguration;
import org.picketlink.idm.internal.DefaultIdentityManager;
import org.picketlink.idm.internal.DefaultIdentityStoreInvocationContextFactory;
import org.picketlink.idm.model.Authorization;
import org.picketlink.idm.spi.IdentityStoreInvocationContextFactory;
import org.picketlink.test.idm.IdentityManagerRunner;
import org.picketlink.test.idm.TestLifecycle;
import org.picketlink.test.idm.basic.AgentManagementTestCase;
import org.picketlink.test.idm.basic.GroupManagementTestCase;
import org.picketlink.test.idm.basic.RoleManagementTestCase;
import org.picketlink.test.idm.basic.UserManagementTestCase;
import org.picketlink.test.idm.credential.CertificateCredentialTestCase;
import org.picketlink.test.idm.credential.DigestCredentialTestCase;
import org.picketlink.test.idm.credential.PasswordCredentialTestCase;
import org.picketlink.test.idm.partition.RealmManagementTestCase;
import org.picketlink.test.idm.partition.TierManagementTestCase;
import org.picketlink.test.idm.query.AgentQueryTestCase;
import org.picketlink.test.idm.query.GroupQueryTestCase;
import org.picketlink.test.idm.query.RelationshipQueryTestCase;
import org.picketlink.test.idm.query.RoleQueryTestCase;
import org.picketlink.test.idm.query.UserQueryTestCase;
import org.picketlink.test.idm.relationship.AgentGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.AgentGroupRoleRelationshipTestCase;
import org.picketlink.test.idm.relationship.AgentGroupsRelationshipTestCase;
import org.picketlink.test.idm.relationship.CustomRelationship;
import org.picketlink.test.idm.relationship.CustomRelationshipTestCase;
import org.picketlink.test.idm.relationship.GroupGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.GroupMembershipTestCase;
import org.picketlink.test.idm.relationship.UserGrantRelationshipTestCase;
import org.picketlink.test.idm.relationship.UserGroupRoleRelationshipTestCase;
import org.picketlink.test.idm.usecases.ApplicationUserRelationshipTestCase;

@RunWith(value=IdentityManagerRunner.class)
@Suite.SuiteClasses(value={RelationshipQueryTestCase.class, CustomRelationshipTestCase.class, RealmManagementTestCase.class, TierManagementTestCase.class, GroupMembershipTestCase.class, ApplicationUserRelationshipTestCase.class, UserManagementTestCase.class, AgentManagementTestCase.class, RoleManagementTestCase.class, GroupManagementTestCase.class, AgentGroupsRelationshipTestCase.class, UserGrantRelationshipTestCase.class, AgentGrantRelationshipTestCase.class, GroupGrantRelationshipTestCase.class, UserGroupRoleRelationshipTestCase.class, AgentGroupRoleRelationshipTestCase.class, RoleQueryTestCase.class, GroupQueryTestCase.class, UserQueryTestCase.class, AgentQueryTestCase.class, PasswordCredentialTestCase.class, CertificateCredentialTestCase.class, DigestCredentialTestCase.class})
public class FileIdentityStoreTestSuite
implements TestLifecycle {
    private static FileIdentityStoreTestSuite instance;

    public static TestLifecycle init() throws Exception {
        if (instance == null) {
            instance = new FileIdentityStoreTestSuite();
        }
        return instance;
    }

    @Override
    public IdentityManager createIdentityManager() {
        IdentityConfiguration config = new IdentityConfiguration();
        FileDataSource dataSource = new FileDataSource();
        dataSource.setAlwaysCreateFiles(true);
        this.addDefaultConfiguration(config, dataSource);
        this.addTestingRealmConfiguration(config, dataSource);
        DefaultIdentityManager identityManager = new DefaultIdentityManager();
        identityManager.bootstrap(config, (IdentityStoreInvocationContextFactory)new DefaultIdentityStoreInvocationContextFactory(null));
        return identityManager;
    }

    private void addTestingRealmConfiguration(IdentityConfiguration config, FileDataSource dataSource) {
        FileIdentityStoreConfiguration fileConfig = new FileIdentityStoreConfiguration();
        fileConfig.addRealm("Testing");
        fileConfig.setDataSource(dataSource);
        FeatureSet.addFeatureSupport((FeatureSet)fileConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[0]);
        FeatureSet.addRelationshipSupport((FeatureSet)fileConfig.getFeatureSet(), (Class[])new Class[0]);
        fileConfig.getFeatureSet().setSupportsCustomRelationships(true);
        fileConfig.getFeatureSet().setSupportsMultiRealm(true);
        config.addStoreConfiguration((IdentityStoreConfiguration)fileConfig);
    }

    private void addDefaultConfiguration(IdentityConfiguration config, FileDataSource dataSource) {
        FileIdentityStoreConfiguration configuration = new FileIdentityStoreConfiguration();
        configuration.setDataSource(dataSource);
        FeatureSet.addFeatureSupport((FeatureSet)configuration.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[0]);
        FeatureSet.addRelationshipSupport((FeatureSet)configuration.getFeatureSet(), (Class[])new Class[0]);
        FeatureSet.addRelationshipSupport((FeatureSet)configuration.getFeatureSet(), (Class[])new Class[]{CustomRelationship.class});
        FeatureSet.addRelationshipSupport((FeatureSet)configuration.getFeatureSet(), (Class[])new Class[]{Authorization.class});
        configuration.getFeatureSet().setSupportsCustomRelationships(true);
        configuration.getFeatureSet().setSupportsMultiRealm(true);
        config.addStoreConfiguration((IdentityStoreConfiguration)configuration);
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onDestroy() {
    }
}

