/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm;

import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.IdentityManagerFactory;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;

public class AbstractIdentityManagerTestCase {
    private IdentityManagerFactory identityManagerFactory;
    private IdentityManager identityManager;

    public IdentityManagerFactory getIdentityManagerFactory() {
        if (this.identityManagerFactory == null) {
            throw new RuntimeException("Identity Manager Factory is not set.");
        }
        return this.identityManagerFactory;
    }

    public IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = this.getIdentityManagerFactory().createIdentityManager();
        }
        return this.identityManager;
    }

    public void setIdentityManagerFactory(IdentityManagerFactory factory) {
        this.identityManagerFactory = factory;
    }

    public void setIdentityManager(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    protected User createUser(String userName) {
        User user = this.getIdentityManager().getUser(userName);
        if (user != null) {
            this.getIdentityManager().remove((IdentityType)user);
        }
        user = new SimpleUser(userName);
        this.getIdentityManager().add((IdentityType)user);
        return user;
    }

    protected User createUser(String userName, Partition partition) {
        IdentityManager identityManager = this.getIdentityManagerForPartition(partition);
        User user = identityManager.getUser(userName);
        if (user != null) {
            identityManager.remove((IdentityType)user);
        }
        user = new SimpleUser(userName);
        identityManager.add((IdentityType)user);
        return user;
    }

    protected User getUser(String userName) {
        return this.getIdentityManager().getUser(userName);
    }

    protected Agent createAgent(String loginName) {
        Agent agent = this.getIdentityManager().getAgent(loginName);
        if (agent != null) {
            this.getIdentityManager().remove((IdentityType)agent);
            agent = null;
        }
        agent = new SimpleAgent(loginName);
        this.getIdentityManager().add((IdentityType)agent);
        return agent;
    }

    protected Agent createAgent(String loginName, Partition partition) {
        IdentityManager identityManager = this.getIdentityManagerForPartition(partition);
        Agent agent = identityManager.getAgent(loginName);
        if (agent != null) {
            identityManager.remove((IdentityType)agent);
            agent = null;
        }
        agent = new SimpleAgent(loginName);
        identityManager.add((IdentityType)agent);
        return agent;
    }

    private IdentityManager getIdentityManagerForPartition(Partition partition) {
        IdentityManagerFactory factory = this.getIdentityManagerFactory();
        if (partition == null) {
            return factory.createIdentityManager();
        }
        return factory.createIdentityManager(partition);
    }

    protected Agent getAgent(String loginName) {
        return this.getIdentityManager().getAgent(loginName);
    }

    protected Role createRole(String name) {
        Role role = this.getIdentityManager().getRole(name);
        if (role != null) {
            this.getIdentityManager().remove((IdentityType)role);
            role = null;
        }
        role = new SimpleRole(name);
        this.getIdentityManager().add((IdentityType)role);
        return role;
    }

    protected Role createRole(String name, Partition partition) {
        IdentityManager identityManager = this.getIdentityManagerForPartition(partition);
        Role role = identityManager.getRole(name);
        if (role != null) {
            identityManager.remove((IdentityType)role);
            role = null;
        }
        role = new SimpleRole(name);
        identityManager.add((IdentityType)role);
        return role;
    }

    protected Role getRole(String name) {
        return this.getIdentityManager().getRole(name);
    }

    protected Group createGroupWithParent(String name, Group parentGroup) {
        Group group;
        String path = name;
        if (parentGroup != null) {
            path = parentGroup.getPath() + "/" + name;
        }
        if ((group = this.getIdentityManager().getGroup(path)) != null) {
            this.getIdentityManager().remove((IdentityType)group);
            group = null;
        }
        if (group == null) {
            group = parentGroup == null ? new SimpleGroup(name) : new SimpleGroup(name, parentGroup);
            this.getIdentityManager().add((IdentityType)group);
        }
        return group;
    }

    protected Group createGroup(String name, String parentGroupName) {
        Group group;
        Group parentGroup = this.getIdentityManager().getGroup(parentGroupName);
        String path = name;
        if (parentGroupName != null) {
            path = "/" + parentGroupName + "/" + name;
            if (parentGroup != null) {
                path = parentGroup.getPath() + "/" + name;
            }
        }
        if ((group = this.getIdentityManager().getGroup(path)) != null) {
            this.getIdentityManager().remove((IdentityType)group);
            group = null;
        }
        if (parentGroup != null) {
            this.getIdentityManager().remove((IdentityType)parentGroup);
            parentGroup = null;
        }
        if (parentGroup == null && parentGroupName != null) {
            parentGroup = new SimpleGroup(parentGroupName);
            this.getIdentityManager().add((IdentityType)parentGroup);
        }
        if (group == null) {
            group = parentGroupName == null ? new SimpleGroup(name) : new SimpleGroup(name, parentGroup);
            this.getIdentityManager().add((IdentityType)group);
        }
        return group;
    }

    protected Group createGroup(String name) {
        return this.createGroup(name, null);
    }

    protected Group createGroup(String name, String parentGroupName, Partition partition) {
        Group group;
        IdentityManager identityManager = this.getIdentityManagerForPartition(partition);
        Group parentGroup = identityManager.getGroup(parentGroupName);
        if (parentGroup != null && parentGroupName != null) {
            identityManager.remove((IdentityType)parentGroup);
            parentGroup = null;
        }
        if (parentGroup == null && parentGroupName != null) {
            parentGroup = new SimpleGroup(parentGroupName);
            identityManager.add((IdentityType)parentGroup);
        }
        if ((group = identityManager.getGroup(name)) != null) {
            identityManager.remove((IdentityType)group);
            group = null;
        }
        if (group == null) {
            group = parentGroupName == null ? new SimpleGroup(name) : new SimpleGroup(name, parentGroup);
            identityManager.add((IdentityType)group);
        }
        return group;
    }

    protected Group getGroup(String name) {
        return this.getIdentityManager().getGroup(name);
    }
}

