/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.relationship.CustomRelationship;

public abstract class AbstractFeaturesSetConfigurationTestCase<T extends IdentityStoreConfiguration> {
    @Test
    public void testMinimalConfigurationForIdentityTypeOperations() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        SimpleUser user = new SimpleUser("someUser");
        this.performGetCreateRemoveIdentityType((IdentityType)user, identityManager);
        SimpleRole role = new SimpleRole("someRole");
        this.performGetCreateRemoveIdentityType((IdentityType)role, identityManager);
        SimpleGroup group = new SimpleGroup("someGroup");
        this.performGetCreateRemoveIdentityType((IdentityType)group, identityManager);
    }

    @Test
    public void testMinimalConfigurationForRelationships() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        User user = identityManager.getUser("someUser");
        if (user != null) {
            identityManager.remove((IdentityType)user);
        }
        user = new SimpleUser("someUser");
        identityManager.add((IdentityType)user);
        Role role = identityManager.getRole("someRole");
        if (role != null) {
            identityManager.remove((IdentityType)role);
        }
        role = new SimpleRole("someRole");
        identityManager.add((IdentityType)role);
        Group group = identityManager.getGroup("someGroup");
        if (group != null) {
            identityManager.remove((IdentityType)group);
        }
        group = new SimpleGroup("someGroup");
        identityManager.add((IdentityType)group);
        identityManager.grantRole((IdentityType)user, role);
        identityManager.grantGroupRole((IdentityType)user, role, group);
        identityManager.addToGroup((Agent)user, group);
    }

    @Test
    public void testMinimalConfigurationForCredentials() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        User user = identityManager.getUser("someUser");
        if (user != null) {
            identityManager.remove((IdentityType)user);
        }
        user = new SimpleUser("someUser");
        identityManager.add((IdentityType)user);
        Password password = new Password("123");
        identityManager.updateCredential((Agent)user, (Object)password);
        identityManager.validateCredentials((Credentials)new UsernamePasswordCredentials(user.getLoginName(), password));
    }

    @Test
    public void failFeatureNotSupportedUserRead() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.user, FeatureSet.FeatureOperation.read);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.getUser("someUser");
            Assert.fail();
        }
        catch (OperationNotSupportedException one) {
            Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.user));
            Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.read));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedUserCreate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.user, FeatureSet.FeatureOperation.create);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            this.performGetCreateRemoveIdentityType((IdentityType)new SimpleUser("someUser"), identityManager);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (OperationNotSupportedException.class.isInstance(ime.getCause())) {
                OperationNotSupportedException one = (OperationNotSupportedException)ime.getCause();
                Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.user));
                Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.create));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedUserDelete() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.user, FeatureSet.FeatureOperation.delete);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            User user = identityManager.getUser("someUser");
            if (user == null) {
                user = new SimpleUser("someUser");
                identityManager.add((IdentityType)user);
            }
            identityManager.remove((IdentityType)user);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (OperationNotSupportedException.class.isInstance(ime.getCause())) {
                OperationNotSupportedException one = (OperationNotSupportedException)ime.getCause();
                Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.user));
                Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.delete));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRoleRead() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.role, FeatureSet.FeatureOperation.read);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.getRole("someRole");
            Assert.fail();
        }
        catch (OperationNotSupportedException one) {
            Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.role));
            Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.read));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRoleCreate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.role, FeatureSet.FeatureOperation.create);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            this.performGetCreateRemoveIdentityType((IdentityType)new SimpleRole("someRole"), identityManager);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (OperationNotSupportedException.class.isInstance(ime.getCause())) {
                OperationNotSupportedException one = (OperationNotSupportedException)ime.getCause();
                Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.role));
                Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.create));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRoleDelete() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.role, FeatureSet.FeatureOperation.delete);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            this.performGetCreateRemoveIdentityType((IdentityType)new SimpleRole("someRole"), identityManager);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (OperationNotSupportedException.class.isInstance(ime.getCause())) {
                OperationNotSupportedException one = (OperationNotSupportedException)ime.getCause();
                Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.role));
                Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.delete));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedGroupRead() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.group, FeatureSet.FeatureOperation.read);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.getGroup("someGroup");
            Assert.fail();
        }
        catch (OperationNotSupportedException one) {
            Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.group));
            Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.read));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedGroupCreate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.group, FeatureSet.FeatureOperation.create);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            this.performGetCreateRemoveIdentityType((IdentityType)new SimpleGroup("someGroup"), identityManager);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (OperationNotSupportedException.class.isInstance(ime.getCause())) {
                OperationNotSupportedException one = (OperationNotSupportedException)ime.getCause();
                Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.group));
                Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.create));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedGroupDelete() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.group, FeatureSet.FeatureOperation.delete);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            SimpleGroup group = new SimpleGroup("someGroup");
            this.performGetCreateRemoveIdentityType((IdentityType)group, identityManager);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (OperationNotSupportedException.class.isInstance(ime.getCause())) {
                OperationNotSupportedException one = (OperationNotSupportedException)ime.getCause();
                Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.group));
                Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.delete));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRelationshipRead() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.read);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            identityManager.createRelationshipQuery(Relationship.class);
            Assert.fail();
        }
        catch (OperationNotSupportedException one) {
            Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.relationship));
            Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.read));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRelationshipCreate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.create);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            SimpleUser user = new SimpleUser("someUser");
            this.performGetCreateRemoveIdentityType((IdentityType)user, identityManager);
            SimpleRole role = new SimpleRole("someRole");
            this.performGetCreateRemoveIdentityType((IdentityType)role, identityManager);
            identityManager.add((Relationship)new Grant((IdentityType)user, (Role)role));
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (OperationNotSupportedException.class.isInstance(ime.getCause())) {
                OperationNotSupportedException one = (OperationNotSupportedException)ime.getCause();
                Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.relationship));
                Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.create));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedCustomRelationship() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().setSupportsCustomRelationships(false);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        SimpleUser user = new SimpleUser("someUser");
        identityManager.add((IdentityType)user);
        SimpleRole role = new SimpleRole("someRole");
        identityManager.add((IdentityType)role);
        CustomRelationship customRelationship = new CustomRelationship();
        customRelationship.setIdentityTypeA((IdentityType)user);
        customRelationship.setIdentityTypeB((IdentityType)role);
        try {
            identityManager.add((Relationship)customRelationship);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                SecurityConfigurationException sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(CustomRelationship.class.getName()));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
        config = new IdentityConfiguration();
        storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet();
        FeatureSet.removeRelationshipSupport((FeatureSet)storeConfig.getFeatureSet(), (Class[])new Class[]{CustomRelationship.class});
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        identityManager = this.createIdentityManager(config);
        try {
            identityManager.add((Relationship)customRelationship);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (OperationNotSupportedException.class.isInstance(ime.getCause())) {
                OperationNotSupportedException one = (OperationNotSupportedException)ime.getCause();
                Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.relationship));
                Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.create));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedRelationshipDelete() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureOperation.delete);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        try {
            IdentityManager identityManager = this.createIdentityManager(config);
            SimpleUser user = new SimpleUser("someUser");
            identityManager.add((IdentityType)user);
            SimpleRole role = new SimpleRole("someRole");
            identityManager.add((IdentityType)role);
            Grant grant = new Grant((IdentityType)user, (Role)role);
            identityManager.add((Relationship)grant);
            identityManager.remove((Relationship)grant);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (OperationNotSupportedException.class.isInstance(ime.getCause())) {
                OperationNotSupportedException one = (OperationNotSupportedException)ime.getCause();
                Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.relationship));
                Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.delete));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedCredentialUpdate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.credential, FeatureSet.FeatureOperation.update);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        SimpleUser user = new SimpleUser("someUser");
        this.performGetCreateRemoveIdentityType((IdentityType)user, identityManager);
        Password password = new Password("123");
        try {
            identityManager.updateCredential((Agent)user, (Object)password);
            Assert.fail();
        }
        catch (OperationNotSupportedException one) {
            Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.credential));
            Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.update));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedCredentialValidate() {
        IdentityConfiguration config = new IdentityConfiguration();
        T storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().removeFeature(FeatureSet.FeatureGroup.credential, FeatureSet.FeatureOperation.validate);
        this.addContextInitializers(storeConfig);
        config.addConfig(storeConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        SimpleUser user = new SimpleUser("someUser");
        User storedType = identityManager.getUser(user.getLoginName());
        if (storedType != null) {
            identityManager.remove((IdentityType)storedType);
        }
        identityManager.add((IdentityType)user);
        Password password = new Password("123");
        identityManager.updateCredential((Agent)user, (Object)password);
        try {
            identityManager.validateCredentials((Credentials)new UsernamePasswordCredentials(user.getLoginName(), password));
            Assert.fail();
        }
        catch (OperationNotSupportedException one) {
            Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.credential));
            Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.validate));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    protected void addContextInitializers(T config) {
    }

    protected abstract T createMinimalConfiguration();

    protected abstract IdentityManager createIdentityManager(IdentityConfiguration var1);

    protected void performGetCreateRemoveIdentityType(IdentityType identityType, IdentityManager identityManager) {
        IdentityType storedType = this.getIdentityType(identityType, identityManager);
        if (storedType != null) {
            identityManager.remove(storedType);
        }
        identityManager.add(identityType);
        storedType = this.getIdentityType(identityType, identityManager);
        Assert.assertNotNull((Object)storedType);
        Assert.assertNotNull((Object)storedType.getId());
        identityManager.remove(storedType);
        storedType = this.getIdentityType(storedType, identityManager);
        Assert.assertNull((Object)storedType);
    }

    protected IdentityType getIdentityType(IdentityType identityType, IdentityManager identityManager) {
        if (User.class.isInstance(identityType)) {
            User user = (User)identityType;
            identityType = identityManager.getUser(user.getLoginName());
        } else if (Agent.class.isInstance(identityType)) {
            Agent agent = (Agent)identityType;
            identityType = identityManager.getAgent(agent.getLoginName());
        } else if (Role.class.isInstance(identityType)) {
            Role role = (Role)identityType;
            identityType = identityManager.getRole(role.getName());
        } else if (Group.class.isInstance(identityType)) {
            Group group = (Group)identityType;
            identityType = identityManager.getGroup(group.getName());
        }
        return identityType;
    }
}

