/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.IdentityManagerFactory;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.credential.AbstractBaseCredentials;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.jpa.internal.JPAContextInitializer;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.IdentityObjectAttribute;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.SecurityContext;

public class CredentialHandlerConfigurationTestCase {
    private EntityManagerFactory emf;
    private EntityManager entityManager;

    @Before
    public void onInit() {
        this.emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
        this.entityManager = this.emf.createEntityManager();
        this.entityManager.getTransaction().begin();
        CustomCredentialHandler.wasSetupCalled = false;
        CustomCredentialHandler.wasValidateCalled = false;
        CustomCredentialHandler.wasUpdateCalled = false;
    }

    @After
    public void onDestroy() {
        this.entityManager.getTransaction().commit();
        this.entityManager.close();
        this.emf.close();
    }

    @Test
    public void testCredentialHandlerLifeCycle() throws Exception {
        IdentityConfiguration configuration = new IdentityConfiguration();
        ((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)configuration.jpaStore().addCredentialHandler(CustomCredentialHandler.class)).addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return CredentialHandlerConfigurationTestCase.this.entityManager;
            }
        })).addRealm(new String[]{"default"})).supportAllFeatures()).setIdentityClass(IdentityObject.class).setAttributeClass(IdentityObjectAttribute.class).setRelationshipClass(RelationshipObject.class).setRelationshipIdentityClass(RelationshipIdentityObject.class).setRelationshipAttributeClass(RelationshipObjectAttribute.class).setCredentialClass(CredentialObject.class).setCredentialAttributeClass(CredentialObjectAttribute.class).setPartitionClass(PartitionObject.class);
        IdentityManagerFactory identityManagerFactory = configuration.buildIdentityManagerFactory();
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        user = identityManager.getUser(user.getLoginName());
        Assert.assertNotNull((Object)user);
        CustomCredentialHandler.Token token = new CustomCredentialHandler.Token("123");
        identityManager.updateCredential((Agent)user, (Object)token);
        Assert.assertTrue((boolean)CustomCredentialHandler.wasSetupCalled);
        Assert.assertTrue((boolean)CustomCredentialHandler.wasUpdateCalled);
        Assert.assertFalse((boolean)CustomCredentialHandler.wasValidateCalled);
        CustomCredentialHandler.TokenCredential credential = new CustomCredentialHandler.TokenCredential(token);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertTrue((boolean)CustomCredentialHandler.wasValidateCalled);
    }

    @Test
    public void testCustomCredentialHandler() throws Exception {
        IdentityConfiguration configuration = new IdentityConfiguration();
        ((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)configuration.jpaStore().addCredentialHandler(CustomCredentialHandler.class)).addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return CredentialHandlerConfigurationTestCase.this.entityManager;
            }
        })).addRealm(new String[]{"default"})).supportAllFeatures()).setIdentityClass(IdentityObject.class).setAttributeClass(IdentityObjectAttribute.class).setRelationshipClass(RelationshipObject.class).setRelationshipIdentityClass(RelationshipIdentityObject.class).setRelationshipAttributeClass(RelationshipObjectAttribute.class).setCredentialClass(CredentialObject.class).setCredentialAttributeClass(CredentialObjectAttribute.class).setPartitionClass(PartitionObject.class);
        IdentityManagerFactory identityManagerFactory = configuration.buildIdentityManagerFactory();
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        user = identityManager.getUser(user.getLoginName());
        Assert.assertNotNull((Object)user);
        CustomCredentialHandler.Token token = new CustomCredentialHandler.Token("123");
        identityManager.updateCredential((Agent)user, (Object)token);
        CustomCredentialHandler.TokenCredential credential = new CustomCredentialHandler.TokenCredential(token);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
        CustomCredentialHandler.TokenCredential badCredential = new CustomCredentialHandler.TokenCredential(new CustomCredentialHandler.Token("bad_token"));
        identityManager.validateCredentials((Credentials)badCredential);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)badCredential.getStatus());
    }

    @SupportsCredentials(value={TokenCredential.class, Token.class})
    public static class CustomCredentialHandler
    implements CredentialHandler {
        public static boolean wasValidateCalled;
        public static boolean wasUpdateCalled;
        public static boolean wasSetupCalled;

        public void validate(SecurityContext context, Credentials credentials, IdentityStore<?> identityStore) {
            TokenCredential credential = (TokenCredential)credentials;
            credential.setStatus(Credentials.Status.INVALID);
            if (credential.getToken().getValue().equals("123")) {
                credential.setStatus(Credentials.Status.VALID);
            }
            wasValidateCalled = true;
        }

        public void update(SecurityContext context, Agent agent, Object credential, IdentityStore<?> identityStore, Date effectiveDate, Date expiryDate) {
            wasUpdateCalled = true;
        }

        public void setup(IdentityStore<?> identityStore) {
            wasSetupCalled = true;
        }

        public static class TokenCredential
        extends AbstractBaseCredentials {
            private Token token;

            public TokenCredential(Token token) {
                this.token = token;
            }

            public void invalidate() {
                this.token = null;
            }

            public Token getToken() {
                return this.token;
            }
        }

        public static class Token {
            private String value;

            public Token(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }
}

