/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.internal.DefaultIdentityManagerFactory;
import org.picketlink.idm.jpa.internal.JPAContextInitializer;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.test.idm.config.AbstractFeaturesSetConfigurationTestCase;
import org.picketlink.test.idm.relationship.CustomRelationship;

public class JPAIdentityStoreConfigurationTestCase
extends AbstractFeaturesSetConfigurationTestCase<JPAIdentityStoreConfiguration> {
    private EntityManagerFactory emf;
    private EntityManager entityManager;

    @Before
    public void onInit() {
        this.emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
        this.entityManager = this.emf.createEntityManager();
        this.entityManager.getTransaction().begin();
    }

    @After
    public void onDestroy() {
        this.entityManager.getTransaction().commit();
        this.entityManager.close();
        this.emf.close();
    }

    @Test
    public void failFeatureNotSupportedWhenEntityClassesNotProvided() {
        SecurityConfigurationException sce;
        IdentityConfiguration config = new IdentityConfiguration();
        JPAIdentityStoreConfiguration jpaConfig = this.createMinimalConfiguration();
        jpaConfig.setRelationshipClass(null);
        jpaConfig.setRelationshipIdentityClass(null);
        jpaConfig.setRelationshipAttributeClass(null);
        this.addContextInitializers(jpaConfig);
        config.addConfig((IdentityStoreConfiguration)jpaConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        SimpleUser user = new SimpleUser("someUser");
        identityManager.add((IdentityType)user);
        SimpleRole role = new SimpleRole("someRole");
        identityManager.add((IdentityType)role);
        SimpleGroup group = new SimpleGroup("someGroup");
        identityManager.add((IdentityType)group);
        try {
            identityManager.add((Relationship)new Grant((IdentityType)user, (Role)role));
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(Grant.class.getName()));
            }
            Assert.fail();
        }
        try {
            identityManager.add((Relationship)new GroupRole((IdentityType)user, (Group)group, (Role)role));
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(GroupRole.class.getName()));
            }
            Assert.fail();
        }
        try {
            identityManager.add((Relationship)new GroupMembership((Agent)user, (Group)group));
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(GroupMembership.class.getName()));
            }
            Assert.fail();
        }
        try {
            CustomRelationship customRelationship = new CustomRelationship();
            customRelationship.setIdentityTypeA((IdentityType)user);
            customRelationship.setIdentityTypeB((IdentityType)role);
            customRelationship.setIdentityTypeC((IdentityType)group);
            identityManager.add((Relationship)customRelationship);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(CustomRelationship.class.getName()));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failFeatureNotSupportedWhenCredentialClassesNotProvided() {
        IdentityConfiguration config = new IdentityConfiguration();
        JPAIdentityStoreConfiguration jpaConfig = this.createMinimalConfiguration();
        jpaConfig.setCredentialClass(null);
        this.addContextInitializers(jpaConfig);
        config.addConfig((IdentityStoreConfiguration)jpaConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        SimpleUser user = new SimpleUser("someUser");
        identityManager.add((IdentityType)user);
        Password password = new Password("123");
        try {
            identityManager.updateCredential((Agent)user, (Object)password);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("[credential.update]"));
        }
        config = new IdentityConfiguration();
        jpaConfig = this.createMinimalConfiguration();
        jpaConfig.setCredentialClass(CredentialObject.class);
        jpaConfig.setCredentialAttributeClass(null);
        this.addContextInitializers(jpaConfig);
        config.addConfig((IdentityStoreConfiguration)jpaConfig);
        identityManager = this.createIdentityManager(config);
        try {
            identityManager.updateCredential((Agent)user, (Object)password);
            Assert.fail();
        }
        catch (OperationNotSupportedException one) {
            Assert.assertTrue((boolean)one.getFeatureGroup().equals((Object)FeatureSet.FeatureGroup.credential));
            Assert.assertTrue((boolean)one.getFeatureOperation().equals((Object)FeatureSet.FeatureOperation.update));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failIdentityClassNotProvided() {
        IdentityConfiguration config = new IdentityConfiguration();
        JPAIdentityStoreConfiguration jpaConfig = new JPAIdentityStoreConfiguration();
        this.addContextInitializers(jpaConfig);
        config.addConfig((IdentityStoreConfiguration)jpaConfig);
        try {
            this.createIdentityManager(config);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("identityclass not set"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void failPartitionClassNotProvided() {
        IdentityConfiguration config = new IdentityConfiguration();
        JPAIdentityStoreConfiguration jpaConfig = new JPAIdentityStoreConfiguration();
        jpaConfig.setIdentityClass(IdentityObject.class);
        this.addContextInitializers(jpaConfig);
        config.addConfig((IdentityStoreConfiguration)jpaConfig);
        try {
            this.createIdentityManager(config);
            Assert.fail();
        }
        catch (SecurityConfigurationException sce) {
            Assert.assertTrue((boolean)sce.getMessage().toLowerCase().contains("partitionclass not set"));
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Override
    protected JPAIdentityStoreConfiguration createMinimalConfiguration() {
        JPAIdentityStoreConfiguration jpaConfig = new JPAIdentityStoreConfiguration();
        jpaConfig.setIdentityClass(IdentityObject.class);
        jpaConfig.setPartitionClass(PartitionObject.class);
        jpaConfig.setRelationshipClass(RelationshipObject.class);
        jpaConfig.setRelationshipIdentityClass(RelationshipIdentityObject.class);
        jpaConfig.setRelationshipAttributeClass(RelationshipObjectAttribute.class);
        jpaConfig.setCredentialClass(CredentialObject.class);
        jpaConfig.setCredentialAttributeClass(CredentialObjectAttribute.class);
        FeatureSet.addFeatureSupport((FeatureSet)jpaConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user});
        FeatureSet.addFeatureSupport((FeatureSet)jpaConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.role});
        FeatureSet.addFeatureSupport((FeatureSet)jpaConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.group});
        FeatureSet.addFeatureSupport((FeatureSet)jpaConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.relationship});
        jpaConfig.getFeatureSet().setSupportsCustomRelationships(true);
        FeatureSet.addRelationshipSupport((FeatureSet)jpaConfig.getFeatureSet(), (Class[])new Class[]{CustomRelationship.class});
        FeatureSet.addFeatureSupport((FeatureSet)jpaConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.credential});
        return jpaConfig;
    }

    @Override
    protected IdentityManager createIdentityManager(IdentityConfiguration config) {
        DefaultIdentityManagerFactory factory = new DefaultIdentityManagerFactory(config);
        return factory.createIdentityManager();
    }

    @Override
    protected void addContextInitializers(JPAIdentityStoreConfiguration config) {
        config.addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return JPAIdentityStoreConfigurationTestCase.this.entityManager;
            }
        });
    }
}

