/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.picketbox.test.ldap.AbstractLDAPTest;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.internal.DefaultIdentityManagerFactory;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.test.idm.config.AbstractFeaturesSetConfigurationTestCase;
import org.picketlink.test.idm.relationship.CustomRelationship;

public class LDAPIdentityStoreConfigurationTestCase
extends AbstractFeaturesSetConfigurationTestCase<LDAPIdentityStoreConfiguration> {
    private static final String BASE_DN = "dc=jboss,dc=org";
    private static final String LDAP_URL = "ldap://localhost:10389";
    private static final String ROLES_DN_SUFFIX = "ou=Roles,dc=jboss,dc=org";
    private static final String GROUP_DN_SUFFIX = "ou=Groups,dc=jboss,dc=org";
    private static final String USER_DN_SUFFIX = "ou=People,dc=jboss,dc=org";
    private static final String AGENT_DN_SUFFIX = "ou=Agent,dc=jboss,dc=org";
    private static AbstractLDAPTest instance;

    @BeforeClass
    public static void onBeforeClass() {
        try {
            instance = new AbstractLDAPTest(){

                @Before
                public void setup() throws Exception {
                    super.setup();
                    this.importLDIF("ldap/users.ldif");
                }
            };
            instance.setup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void onDestroyClass() {
        try {
            instance.tearDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Test
    public void failFeatureNotSupportedCustomRelationship() {
        IdentityConfiguration config = new IdentityConfiguration();
        LDAPIdentityStoreConfiguration storeConfig = this.createMinimalConfiguration();
        storeConfig.getFeatureSet().setSupportsCustomRelationships(true);
        config.addConfig((IdentityStoreConfiguration)storeConfig);
        IdentityManager identityManager = this.createIdentityManager(config);
        SimpleUser user = new SimpleUser("someUser");
        identityManager.add((IdentityType)user);
        SimpleRole role = new SimpleRole("someRole");
        identityManager.add((IdentityType)role);
        CustomRelationship customRelationship = new CustomRelationship();
        customRelationship.setIdentityTypeA((IdentityType)user);
        customRelationship.setIdentityTypeB((IdentityType)role);
        try {
            identityManager.add((Relationship)customRelationship);
            Assert.fail();
        }
        catch (IdentityManagementException ime) {
            if (SecurityConfigurationException.class.isInstance(ime.getCause())) {
                SecurityConfigurationException sce = (SecurityConfigurationException)ime.getCause();
                Assert.assertTrue((boolean)sce.getMessage().contains(CustomRelationship.class.getName()));
            } else {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Override
    protected LDAPIdentityStoreConfiguration createMinimalConfiguration() {
        LDAPIdentityStoreConfiguration fileConfig = new LDAPIdentityStoreConfiguration();
        fileConfig.setBaseDN(BASE_DN).setBindDN("uid=admin,ou=system").setBindCredential("secret").setLdapURL(LDAP_URL).setUserDNSuffix(USER_DN_SUFFIX).setRoleDNSuffix(ROLES_DN_SUFFIX).setAgentDNSuffix(AGENT_DN_SUFFIX).setGroupDNSuffix(GROUP_DN_SUFFIX);
        fileConfig.addGroupMapping("/QA Group", "ou=QA,dc=jboss,dc=org");
        FeatureSet.addFeatureSupport((FeatureSet)fileConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[0]);
        FeatureSet.addRelationshipSupport((FeatureSet)fileConfig.getFeatureSet(), (Class[])new Class[0]);
        FeatureSet.addFeatureSupport((FeatureSet)fileConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user});
        FeatureSet.addFeatureSupport((FeatureSet)fileConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.role});
        FeatureSet.addFeatureSupport((FeatureSet)fileConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.group});
        FeatureSet.addFeatureSupport((FeatureSet)fileConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.relationship});
        FeatureSet.addRelationshipSupport((FeatureSet)fileConfig.getFeatureSet(), (Class[])new Class[]{CustomRelationship.class});
        fileConfig.getFeatureSet().setSupportsCustomRelationships(true);
        FeatureSet.addFeatureSupport((FeatureSet)fileConfig.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.credential});
        return fileConfig;
    }

    @Override
    protected IdentityManager createIdentityManager(IdentityConfiguration config) {
        DefaultIdentityManagerFactory factory = new DefaultIdentityManagerFactory(config);
        return factory.createIdentityManager();
    }
}

