/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.config;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketbox.test.ldap.AbstractLDAPTest;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.IdentityManagerFactory;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.jpa.internal.JPAContextInitializer;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.IdentityObjectAttribute;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityWeakObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.Authorization;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.test.idm.relationship.CustomRelationship;

public class ProgrammaticConfigurationTestCase
extends AbstractLDAPTest {
    private static final String BASE_DN = "dc=jboss,dc=org";
    private static final String LDAP_URL = "ldap://localhost:10389";
    private static final String ROLES_DN_SUFFIX = "ou=Roles,dc=jboss,dc=org";
    private static final String GROUP_DN_SUFFIX = "ou=Groups,dc=jboss,dc=org";
    private static final String USER_DN_SUFFIX = "ou=People,dc=jboss,dc=org";
    private static final String AGENT_DN_SUFFIX = "ou=Agent,dc=jboss,dc=org";
    private EntityManagerFactory emf;
    private EntityManager entityManager;

    @Before
    public void onInit() throws Exception {
        this.emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
        this.entityManager = this.emf.createEntityManager();
        this.entityManager.getTransaction().begin();
        super.importLDIF("ldap/users.ldif");
    }

    @After
    public void onDestroy() throws Exception {
        this.entityManager.getTransaction().commit();
        this.entityManager.close();
        this.emf.close();
        super.tearDown();
    }

    @Test
    public void testFileIdentityStoreConfiguration() throws Exception {
        IdentityConfiguration configuration = new IdentityConfiguration();
        ((FileIdentityStoreConfiguration)((FileIdentityStoreConfiguration)((FileIdentityStoreConfiguration)configuration.fileStore().setAlwaysCreateFiles(true).setWorkingDir("/tmp/pl-idm").setAsyncWrite(true).setAsyncThreadPool(10).addRealm(new String[]{"default"})).addRealm(new String[]{"Realm"})).addTier(new String[]{"Tier"})).supportAllFeatures();
        IdentityManagerFactory identityManagerFactory = configuration.buildIdentityManagerFactory();
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        Assert.assertNotNull((Object)identityManager.getUser(user.getLoginName()));
    }

    @Test
    public void testJPAIdentityStoreConfiguration() throws Exception {
        IdentityConfiguration configuration = new IdentityConfiguration();
        ((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)configuration.jpaStore().addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return ProgrammaticConfigurationTestCase.this.entityManager;
            }
        })).setIdentityClass(IdentityObject.class).setAttributeClass(IdentityObjectAttribute.class).setRelationshipClass(RelationshipObject.class).setRelationshipIdentityClass(RelationshipIdentityObject.class).setRelationshipAttributeClass(RelationshipObjectAttribute.class).setCredentialClass(CredentialObject.class).setCredentialAttributeClass(CredentialObjectAttribute.class).setPartitionClass(PartitionObject.class).addRealm(new String[]{"default"})).addRealm(new String[]{"Realm"})).addTier(new String[]{"Tier"})).supportAllFeatures();
        IdentityManagerFactory identityManagerFactory = configuration.buildIdentityManagerFactory();
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        Assert.assertNotNull((Object)identityManager.getUser(user.getLoginName()));
    }

    @Test
    public void testLDAPIdentityStoreConfiguration() throws Exception {
        IdentityConfiguration configuration = new IdentityConfiguration();
        ((LDAPIdentityStoreConfiguration)configuration.ldapStore().setBaseDN(BASE_DN).setBindDN("uid=admin,ou=system").setBindCredential("secret").setLdapURL(LDAP_URL).setUserDNSuffix(USER_DN_SUFFIX).setRoleDNSuffix(ROLES_DN_SUFFIX).setAgentDNSuffix(AGENT_DN_SUFFIX).setGroupDNSuffix(GROUP_DN_SUFFIX).addRealm(new String[]{"default"})).supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.agent, FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.group, FeatureSet.FeatureGroup.role, FeatureSet.FeatureGroup.attribute, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureGroup.credential});
        IdentityManagerFactory identityManagerFactory = configuration.buildIdentityManagerFactory();
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        Assert.assertNotNull((Object)identityManager.getUser(user.getLoginName()));
    }

    @Test
    public void testLDAPAndJPAIdentityStoreConfiguration() throws Exception {
        IdentityConfiguration configuration = new IdentityConfiguration();
        ((LDAPIdentityStoreConfiguration)configuration.ldapStore().setBaseDN(BASE_DN).setBindDN("uid=admin,ou=system").setBindCredential("secret").setLdapURL(LDAP_URL).setUserDNSuffix(USER_DN_SUFFIX).setRoleDNSuffix(ROLES_DN_SUFFIX).setAgentDNSuffix(AGENT_DN_SUFFIX).setGroupDNSuffix(GROUP_DN_SUFFIX).addGroupMapping("/QA Group", "ou=QA,dc=jboss,dc=org").addRealm(new String[]{"default"})).supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.agent, FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.group, FeatureSet.FeatureGroup.role, FeatureSet.FeatureGroup.attribute, FeatureSet.FeatureGroup.credential});
        ((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)configuration.jpaStore().addRealm(new String[]{"default"})).setIdentityClass(IdentityObject.class).setAttributeClass(IdentityObjectAttribute.class).setRelationshipClass(RelationshipObject.class).setRelationshipIdentityClass(RelationshipIdentityWeakObject.class).setRelationshipAttributeClass(RelationshipObjectAttribute.class).setPartitionClass(PartitionObject.class).supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.relationship})).supportRelationshipType(new Class[]{CustomRelationship.class, Authorization.class})).addContextInitializer((ContextInitializer)new JPAContextInitializer(this.emf){

            public EntityManager getEntityManager() {
                return ProgrammaticConfigurationTestCase.this.entityManager;
            }
        });
        IdentityManagerFactory identityManagerFactory = configuration.buildIdentityManagerFactory();
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        SimpleUser user = new SimpleUser("user");
        identityManager.add((IdentityType)user);
        SimpleRole role = new SimpleRole("role");
        identityManager.add((IdentityType)role);
        identityManager.grantRole((IdentityType)user, (Role)role);
        Assert.assertNotNull((Object)identityManager.getUser(user.getLoginName()));
        Assert.assertTrue((boolean)identityManager.hasRole((IdentityType)user, (Role)role));
    }

    @Test
    public void failDuplicatedFeatureConfiguration() throws Exception {
        IdentityConfiguration configuration = new IdentityConfiguration();
        configuration.fileStore().supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user});
        configuration.jpaStore().supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user});
        try {
            configuration.buildIdentityManagerFactory();
            Assert.fail();
        }
        catch (SecurityConfigurationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("PLIDM000069"));
            if (!e.getCause().getMessage().contains("PLIDM000071")) {
                Assert.fail();
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

