/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.credential;

import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Digest;
import org.picketlink.idm.credential.DigestCredentials;
import org.picketlink.idm.credential.internal.DigestUtil;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.User;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class DigestCredentialTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testSuccessfulValidation() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        Digest digestPassword = new Digest();
        digestPassword.setRealm("pl-idm");
        digestPassword.setUsername(user.getLoginName());
        digestPassword.setPassword("somePassword");
        identityManager.updateCredential((Agent)user, (Object)digestPassword);
        digestPassword.setDigest(DigestUtil.calculateA1((String)user.getLoginName(), (String)digestPassword.getRealm(), (char[])digestPassword.getPassword().toCharArray()));
        DigestCredentials credential = new DigestCredentials(digestPassword);
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
        Assert.assertNotNull((Object)credential.getValidatedAgent());
        Assert.assertEquals((Object)user.getId(), (Object)credential.getValidatedAgent().getId());
    }

    @Test
    public void testUnsuccessfulValidation() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        Digest digestPassword = new Digest();
        digestPassword.setRealm("pl-idm");
        digestPassword.setUsername(user.getLoginName());
        digestPassword.setPassword("somePassword");
        identityManager.updateCredential((Agent)user, (Object)digestPassword);
        digestPassword.setDigest(DigestUtil.calculateA1((String)("Bad" + user.getLoginName()), (String)digestPassword.getRealm(), (char[])digestPassword.getPassword().toCharArray()));
        DigestCredentials badUserName = new DigestCredentials(digestPassword);
        identityManager.validateCredentials((Credentials)badUserName);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)badUserName.getStatus());
        Assert.assertNull((Object)badUserName.getValidatedAgent());
        digestPassword = new Digest();
        digestPassword.setRealm("pl-idm");
        digestPassword.setUsername(user.getLoginName());
        digestPassword.setPassword("bad_somePassword");
        digestPassword.setDigest(DigestUtil.calculateA1((String)user.getLoginName(), (String)digestPassword.getRealm(), (char[])digestPassword.getPassword().toCharArray()));
        DigestCredentials badPassword = new DigestCredentials(digestPassword);
        identityManager.validateCredentials((Credentials)badPassword);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)badPassword.getStatus());
        Assert.assertNull((Object)badPassword.getValidatedAgent());
    }

    @Test
    public void testExpiration() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        Digest digest = new Digest();
        digest.setRealm("pl-idm");
        digest.setUsername(user.getLoginName());
        digest.setPassword("somePassword");
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.add(12, -1);
        identityManager.updateCredential((Agent)user, (Object)digest, new Date(), expirationDate.getTime());
        DigestCredentials credential = new DigestCredentials(digest);
        digest.setDigest(DigestUtil.calculateA1((String)user.getLoginName(), (String)digest.getRealm(), (char[])digest.getPassword().toCharArray()));
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.EXPIRED, (Object)credential.getStatus());
        Digest newPassword = new Digest();
        newPassword.setRealm("pl-idm");
        newPassword.setUsername(user.getLoginName());
        newPassword.setPassword("someNewPassword");
        identityManager.updateCredential((Agent)user, (Object)newPassword);
        credential = new DigestCredentials(newPassword);
        newPassword.setDigest(DigestUtil.calculateA1((String)user.getLoginName(), (String)newPassword.getRealm(), (char[])newPassword.getPassword().toCharArray()));
        identityManager.validateCredentials((Credentials)credential);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)credential.getStatus());
    }

    @Test
    public void testMultipleRealms() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        User user = this.createUser("someUser");
        Digest realmAPassword = new Digest();
        realmAPassword.setRealm("Realm A");
        realmAPassword.setUsername(user.getLoginName());
        realmAPassword.setPassword("somePassword");
        identityManager.updateCredential((Agent)user, (Object)realmAPassword);
        Digest realmBPassword = new Digest();
        realmBPassword.setRealm("Realm B");
        realmBPassword.setUsername(user.getLoginName());
        realmBPassword.setPassword("somePassword");
        identityManager.updateCredential((Agent)user, (Object)realmBPassword);
        realmAPassword.setDigest(DigestUtil.calculateA1((String)user.getLoginName(), (String)realmAPassword.getRealm(), (char[])realmAPassword.getPassword().toCharArray()));
        DigestCredentials realmACredentials = new DigestCredentials(realmAPassword);
        identityManager.validateCredentials((Credentials)realmACredentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)realmACredentials.getStatus());
        realmBPassword.setDigest(DigestUtil.calculateA1((String)user.getLoginName(), (String)realmBPassword.getRealm(), (char[])realmBPassword.getPassword().toCharArray()));
        DigestCredentials realmBCredentials = new DigestCredentials(realmBPassword);
        identityManager.validateCredentials((Credentials)realmBCredentials);
        Assert.assertEquals((Object)Credentials.Status.VALID, (Object)realmBCredentials.getStatus());
        realmBPassword.setDigest(DigestUtil.calculateA1((String)user.getLoginName(), (String)realmAPassword.getRealm(), (char[])realmBPassword.getPassword().toCharArray()));
        realmBCredentials = new DigestCredentials(realmBPassword);
        identityManager.validateCredentials((Credentials)realmBCredentials);
        Assert.assertEquals((Object)Credentials.Status.INVALID, (Object)realmBCredentials.getStatus());
    }
}

