/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.performance;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.IdentityManagerFactory;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.jpa.internal.JPAContextInitializer;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.IdentityObjectAttribute;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.spi.ContextInitializer;

public class JPAIdentityStoreLoadUsersJMeterTest
extends AbstractJavaSamplerClient {
    private static EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"jpa-identity-store-tests-pu");
    private static IdentityManagerFactory identityManagerFactory = null;
    private static final ThreadLocal<EntityManager> entityManager = new ThreadLocal();

    private static void closeEntityManager() {
        entityManager.get().getTransaction().commit();
        entityManager.get().close();
        entityManager.remove();
    }

    private static void initializeEntityManager() {
        entityManager.set(emf.createEntityManager());
        entityManager.get().getTransaction().begin();
    }

    public Arguments getDefaultParameters() {
        Arguments arguments = new Arguments();
        arguments.addArgument("loginName", "Sample User");
        return arguments;
    }

    public void setupTest(JavaSamplerContext context) {
    }

    public void teardownTest(JavaSamplerContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult runTest(JavaSamplerContext context) {
        SampleResult result = new SampleResult();
        result.sampleStart();
        boolean success = false;
        String loginName = context.getParameter("loginName");
        if (loginName == null) {
            loginName = "Sample User";
        }
        JMeterVariables vars = JMeterContextService.getContext().getVariables();
        vars.put("loginName", loginName);
        try {
            JPAIdentityStoreLoadUsersJMeterTest.initializeEntityManager();
            SimpleUser user = new SimpleUser(loginName);
            IdentityManager identityManager = identityManagerFactory.createIdentityManager();
            identityManager.add((IdentityType)user);
            success = user.getId() != null && identityManager.getUser(loginName) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            result.sampleEnd();
            result.setSuccessful(success);
            JPAIdentityStoreLoadUsersJMeterTest.closeEntityManager();
        }
        return result;
    }

    private static IdentityManagerFactory createIdentityManagerFactory() {
        IdentityConfiguration configuration = new IdentityConfiguration();
        ((JPAIdentityStoreConfiguration)((JPAIdentityStoreConfiguration)configuration.jpaStore().addRealm(new String[]{"default", "Testing"})).setIdentityClass(IdentityObject.class).setAttributeClass(IdentityObjectAttribute.class).setPartitionClass(PartitionObject.class).supportAllFeatures()).addContextInitializer((ContextInitializer)new JPAContextInitializer(emf){

            public EntityManager getEntityManager() {
                return (EntityManager)entityManager.get();
            }
        });
        return configuration.buildIdentityManagerFactory();
    }

    static {
        identityManagerFactory = JPAIdentityStoreLoadUsersJMeterTest.createIdentityManagerFactory();
        JPAIdentityStoreLoadUsersJMeterTest.initializeEntityManager();
        IdentityManager identityManager = identityManagerFactory.createIdentityManager();
        identityManager.add((IdentityType)new SimpleUser("testingUser"));
        JPAIdentityStoreLoadUsersJMeterTest.closeEntityManager();
    }
}

