/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.performance;

import java.util.List;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.SampleResult;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.internal.DefaultIdentityManagerFactory;
import org.picketlink.idm.model.Authorization;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.relationship.CustomRelationship;

public class ReadUsersJMeterTest
extends AbstractJavaSamplerClient {
    private static IdentityManager identityManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult runTest(JavaSamplerContext context) {
        SampleResult result = new SampleResult();
        result.sampleStart();
        boolean success = false;
        try {
            IdentityQuery query = identityManager.createIdentityQuery(User.class);
            query.setParameter(User.ENABLED, new Object[]{true});
            List users = query.getResultList();
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            result.sampleEnd();
            result.setSuccessful(success);
        }
        return result;
    }

    private static IdentityManager createIdentityManager() {
        IdentityConfiguration config = new IdentityConfiguration();
        ReadUsersJMeterTest.addDefaultConfiguration(config);
        DefaultIdentityManagerFactory factory = new DefaultIdentityManagerFactory(config);
        return factory.createIdentityManager();
    }

    private static void addDefaultConfiguration(IdentityConfiguration config) {
        FileIdentityStoreConfiguration configuration = new FileIdentityStoreConfiguration();
        configuration.addRealm(new String[]{"default"});
        configuration.addRealm(new String[]{"Testing"});
        configuration.setAlwaysCreateFiles(false);
        FeatureSet.addFeatureSupport((FeatureSet)configuration.getFeatureSet(), (FeatureSet.FeatureGroup[])new FeatureSet.FeatureGroup[0]);
        FeatureSet.addRelationshipSupport((FeatureSet)configuration.getFeatureSet(), (Class[])new Class[0]);
        FeatureSet.addRelationshipSupport((FeatureSet)configuration.getFeatureSet(), (Class[])new Class[]{CustomRelationship.class});
        FeatureSet.addRelationshipSupport((FeatureSet)configuration.getFeatureSet(), (Class[])new Class[]{Authorization.class});
        configuration.getFeatureSet().setSupportsCustomRelationships(true);
        configuration.getFeatureSet().setSupportsMultiRealm(true);
        config.addConfig((IdentityStoreConfiguration)configuration);
    }

    static {
        identityManager = ReadUsersJMeterTest.createIdentityManager();
    }
}

