/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;
import org.picketlink.test.idm.ExcludeTestSuite;
import org.picketlink.test.idm.suites.LDAPIdentityStoreTestSuite;
import org.picketlink.test.idm.suites.LDAPIdentityStoreWithoutAttributesTestSuite;
import org.picketlink.test.idm.suites.LDAPJPAMixedStoreTestSuite;

public abstract class AbstractIdentityQueryTestCase<T extends IdentityType>
extends AbstractIdentityManagerTestCase {
    protected abstract T createIdentityType(String var1, Partition var2);

    protected abstract T getIdentityType();

    @Test
    public void testFindById() throws Exception {
        T identityType = this.createIdentityType(null, null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter(AttributedType.ID, new Object[]{identityType.getId()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)identityType.getId(), (String)((IdentityType)result.get(0)).getId());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class, LDAPJPAMixedStoreTestSuite.class})
    public void testPagination() throws Exception {
        Object identityType = null;
        for (int i = 0; i < 50; ++i) {
            identityType = this.createIdentityType("someIdentityType" + (i + 1), null);
        }
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(identityType.getClass());
        query.setLimit(10);
        query.setOffset(0);
        int resultCount = query.getResultCount();
        junit.framework.Assert.assertEquals((int)50, (int)resultCount);
        List firstPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)firstPage.size());
        ArrayList<String> agentIds = new ArrayList<String>();
        for (IdentityType result : firstPage) {
            agentIds.add(result.getId());
        }
        query.setOffset(10);
        List secondPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)secondPage.size());
        for (IdentityType result : secondPage) {
            junit.framework.Assert.assertFalse((boolean)agentIds.contains(result.getId()));
            agentIds.add(result.getId());
        }
        query.setOffset(20);
        List thirdPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)thirdPage.size());
        for (IdentityType result : thirdPage) {
            junit.framework.Assert.assertFalse((boolean)agentIds.contains(result.getId()));
            agentIds.add(result.getId());
        }
        query.setOffset(30);
        List fourthPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)fourthPage.size());
        for (IdentityType result : fourthPage) {
            junit.framework.Assert.assertFalse((boolean)agentIds.contains(result.getId()));
            agentIds.add(result.getId());
        }
        query.setOffset(40);
        List fifthyPage = query.getResultList();
        junit.framework.Assert.assertEquals((int)10, (int)fifthyPage.size());
        for (IdentityType result : fifthyPage) {
            junit.framework.Assert.assertFalse((boolean)agentIds.contains(result.getId()));
            agentIds.add(result.getId());
        }
        junit.framework.Assert.assertEquals((int)50, (int)agentIds.size());
        query.setOffset(50);
        List invalidPage = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)invalidPage.isEmpty());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreTestSuite.class, LDAPIdentityStoreWithoutAttributesTestSuite.class, LDAPJPAMixedStoreTestSuite.class})
    public void testFindByRealm() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        T someTypeDefaultRealm = this.createIdentityType(null, null);
        IdentityQuery query = identityManager.createIdentityQuery(someTypeDefaultRealm.getClass());
        Realm defaultRealm = this.getIdentityManagerFactory().getRealm("default");
        Assert.assertNotNull((Object)defaultRealm);
        query.setParameter(IdentityType.PARTITION, new Object[]{defaultRealm});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)someTypeDefaultRealm.getId(), (String)((IdentityType)result.get(0)).getId());
        Realm testingRealm = this.getIdentityManagerFactory().getRealm("Testing");
        Assert.assertNotNull((Object)testingRealm);
        T someAnotherTypeTestingRealm = this.createIdentityType("someAnotherType", (Partition)testingRealm);
        query = this.getIdentityManagerFactory().createIdentityManager((Partition)testingRealm).createIdentityQuery(someTypeDefaultRealm.getClass());
        query.setParameter(Agent.PARTITION, new Object[]{testingRealm});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)someAnotherTypeTestingRealm.getId(), (String)((IdentityType)result.get(0)).getId());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindEnabledAndDisabled() throws Exception {
        T someType = this.createIdentityType(null, null);
        T someAnotherType = this.createIdentityType("someAnotherAgent", null);
        someType.setEnabled(true);
        someAnotherType.setEnabled(true);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(someType);
        identityManager.update(someAnotherType);
        IdentityQuery query = identityManager.createIdentityQuery(someType.getClass());
        query.setParameter(IdentityType.ENABLED, new Object[]{true});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherType.getId()));
        query = identityManager.createIdentityQuery(someType.getClass());
        query.setParameter(IdentityType.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        someType.setEnabled(false);
        identityManager.update(someType);
        query = identityManager.createIdentityQuery(someType.getClass());
        query.setParameter(IdentityType.ENABLED, new Object[]{false});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someType.getId()));
        someAnotherType.setEnabled(false);
        identityManager.update(someAnotherType);
        query = identityManager.createIdentityQuery(someType.getClass());
        query.setParameter(IdentityType.ENABLED, new Object[]{true});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindCreationDate() throws Exception {
        T identityType = this.createIdentityType(null, null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter(IdentityType.CREATED_DATE, new Object[]{identityType.getCreatedDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)identityType.getId(), (String)((IdentityType)result.get(0)).getId());
        query = identityManager.createIdentityQuery(identityType.getClass());
        Calendar futureDate = Calendar.getInstance();
        futureDate.add(12, 1);
        query.setParameter(IdentityType.CREATED_DATE, new Object[]{futureDate.getTime()});
        junit.framework.Assert.assertTrue((boolean)query.getResultList().isEmpty());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindExpiryDate() throws Exception {
        T identityType = this.createIdentityType(null, null);
        Date expirationDate = new Date();
        IdentityManager identityManager = this.getIdentityManager();
        identityType = this.getIdentityType();
        identityType.setExpirationDate(expirationDate);
        identityManager.update(identityType);
        IdentityQuery query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter(IdentityType.EXPIRY_DATE, new Object[]{identityType.getExpirationDate()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertEquals((String)identityType.getId(), (String)((IdentityType)result.get(0)).getId());
        query = identityManager.createIdentityQuery(identityType.getClass());
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, 1);
        query.setParameter(IdentityType.EXPIRY_DATE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testFindBetweenCreationDate() throws Exception {
        T identityType = this.createIdentityType(null, null);
        T someAnotherIdentityType = this.createIdentityType("someAnotherAgent", null);
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(identityType.getClass());
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        query.setParameter(IdentityType.CREATED_AFTER, new Object[]{calendar.getTime()});
        query.setParameter(IdentityType.CREATED_BEFORE, new Object[]{new Date()});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherIdentityType.getId()));
        query = identityManager.createIdentityQuery(identityType.getClass());
        T someFutureType = this.createIdentityType("someFutureAgent", null);
        T someAnotherFutureType = this.createIdentityType("someAnotherFutureAgent", null);
        query.setParameter(IdentityType.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherIdentityType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureType.getId()));
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter(IdentityType.CREATED_BEFORE, new Object[]{new Date()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherIdentityType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureType.getId()));
        query = identityManager.createIdentityQuery(identityType.getClass());
        calendar = Calendar.getInstance();
        calendar.add(12, 1);
        query.setParameter(IdentityType.CREATED_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindBetweenExpirationDate() throws Exception {
        T identityType = this.createIdentityType(null, null);
        Date currentDate = new Date();
        identityType.setExpirationDate(currentDate);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(identityType);
        T someAnotherType = this.createIdentityType("someAnotherAgent", null);
        someAnotherType.setExpirationDate(currentDate);
        identityManager.update(someAnotherType);
        IdentityQuery query = identityManager.createIdentityQuery(identityType.getClass());
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        Date expiryDate = calendar.getTime();
        query.setParameter(IdentityType.EXPIRY_AFTER, new Object[]{expiryDate});
        query.setParameter(IdentityType.EXPIRY_BEFORE, new Object[]{currentDate});
        T someFutureType = this.createIdentityType("someFutureAgent", null);
        calendar = Calendar.getInstance();
        calendar.add(12, 1);
        someFutureType.setExpirationDate(calendar.getTime());
        identityManager.update(someFutureType);
        T someAnotherFutureType = this.createIdentityType("someAnotherFutureAgent", null);
        someAnotherFutureType.setExpirationDate(calendar.getTime());
        identityManager.update(someAnotherFutureType);
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)2, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherType.getId()));
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter(IdentityType.EXPIRY_AFTER, new Object[]{expiryDate});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureType.getId()));
        query = identityManager.createIdentityQuery(identityType.getClass());
        calendar = Calendar.getInstance();
        calendar.add(12, 1);
        query.setParameter(IdentityType.EXPIRY_BEFORE, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)4, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someFutureType.getId()));
        junit.framework.Assert.assertTrue((boolean)this.contains(result, someAnotherFutureType.getId()));
        query = identityManager.createIdentityQuery(identityType.getClass());
        calendar = Calendar.getInstance();
        calendar.add(12, 2);
        query.setParameter(IdentityType.EXPIRY_AFTER, new Object[]{calendar.getTime()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindByMultipleParameters() throws Exception {
        T identityType = this.createIdentityType(null, null);
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(identityType);
        identityType.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        identityManager.update(identityType);
        IdentityQuery query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter(IdentityType.ENABLED, new Object[]{identityType.isEnabled()});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        query.setParameter(IdentityType.ENABLED, new Object[]{identityType.isEnabled()});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        query.setParameter(IdentityType.ENABLED, new Object[]{!identityType.isEnabled()});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindByDefinedAttributes() throws Exception {
        T identityType = this.createIdentityType(null, null);
        identityType.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValue")));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(identityType);
        IdentityQuery query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        identityType.setAttribute(new Attribute("someAttribute", (Serializable)((Object)"someAttributeValueChanged")));
        identityManager.update(identityType);
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityType.setAttribute(new Attribute("someAttribute2", (Serializable)((Object)"someAttributeValue2")));
        identityManager.update(identityType);
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
    }

    @Test
    @ExcludeTestSuite(value={LDAPIdentityStoreWithoutAttributesTestSuite.class})
    public void testFindByMultiValuedAttributes() throws Exception {
        T identityType = this.createIdentityType(null, null);
        identityType.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValue2"}));
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.update(identityType);
        IdentityQuery query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        List result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttributeValue1", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValueChanged", "someAttributeValue2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
        identityType.setAttribute(new Attribute("someAttribute", (Serializable)new String[]{"someAttributeValue1", "someAttributeValueChanged"}));
        identityType.setAttribute(new Attribute("someAttribute2", (Serializable)new String[]{"someAttribute2Value1", "someAttribute2Value2"}));
        identityManager.update(identityType);
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2Value1", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((int)1, (int)result.size());
        junit.framework.Assert.assertTrue((boolean)this.contains(result, identityType.getId()));
        query = identityManager.createIdentityQuery(identityType.getClass());
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute"), new Object[]{"someAttributeValue1", "someAttributeValueChanged"});
        query.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"someAttribute2"), new Object[]{"someAttribute2ValueChanged", "someAttribute2Value2"});
        result = query.getResultList();
        junit.framework.Assert.assertTrue((boolean)result.isEmpty());
    }

    protected boolean contains(List<T> result, String id) {
        for (IdentityType identityType : result) {
            if (!identityType.getId().equals(id)) continue;
            return true;
        }
        return false;
    }
}

