/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.query;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class RelationshipQueryTestCase
extends AbstractIdentityManagerTestCase {
    @Test
    public void testFindAllRelationshipsForUser() throws Exception {
        User user = this.createUser("user");
        Role role = this.createRole("role");
        Group group = this.createGroup("group");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole((IdentityType)user, role);
        identityManager.grantGroupRole((IdentityType)user, role, group);
        identityManager.addToGroup((Agent)user, group);
        RelationshipQuery query = identityManager.createRelationshipQuery(Relationship.class);
        query.setParameter(Relationship.IDENTITY, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
        query = identityManager.createRelationshipQuery(Relationship.class);
        query.setParameter(Relationship.IDENTITY, new Object[]{role});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        query = identityManager.createRelationshipQuery(Relationship.class);
        query.setParameter(Relationship.IDENTITY, new Object[]{group});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        query = identityManager.createRelationshipQuery(Relationship.class);
        query.setParameter(Relationship.IDENTITY, new Object[]{user.getId()});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)3L, (long)result.size());
    }
}

