/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.relationship;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public abstract class AbstractGrantRelationshipTestCase<T extends IdentityType>
extends AbstractIdentityManagerTestCase {
    protected abstract T createIdentityType(String var1, Partition var2);

    protected abstract T createIdentityType(String var1);

    protected abstract T getIdentityType();

    @Test
    public void testGrantRoleToAgent() throws Exception {
        T someAgent = this.createIdentityType("someAgent");
        Role someRole = this.createRole("someRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole(someAgent, someRole);
        Assert.assertTrue((boolean)identityManager.hasRole(someAgent, someRole));
        Role someAnotherRole = this.createRole("someAnotherRole");
        Assert.assertFalse((boolean)identityManager.hasRole(someAgent, someAnotherRole));
        identityManager.grantRole(someAgent, someAnotherRole);
        Assert.assertTrue((boolean)identityManager.hasRole(someAgent, someAnotherRole));
        Assert.assertTrue((boolean)identityManager.hasRole(someAgent, someRole));
    }

    @Test
    public void testRevokeRoleFromAgent() throws Exception {
        T someAgent = this.createIdentityType("someAgent");
        Role someRole = this.createRole("someRole");
        Role someAnotherRole = this.createRole("someAnotherRole");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.grantRole(someAgent, someRole);
        identityManager.grantRole(someAgent, someAnotherRole);
        Assert.assertTrue((boolean)identityManager.hasRole(someAgent, someRole));
        Assert.assertTrue((boolean)identityManager.hasRole(someAgent, someAnotherRole));
        identityManager.revokeRole(someAgent, someRole);
        Assert.assertFalse((boolean)identityManager.hasRole(someAgent, someRole));
        Assert.assertTrue((boolean)identityManager.hasRole(someAgent, someAnotherRole));
        identityManager.revokeRole(someAgent, someAnotherRole);
        Assert.assertFalse((boolean)identityManager.hasRole(someAgent, someAnotherRole));
    }

    @Test
    public void testFindAgentRoles() throws Exception {
        Role someRole = this.createRole("someRole");
        Role someAnotherRole = this.createRole("someAnotherRole");
        Role someImportantRole = this.createRole("someImportantRole");
        T user = this.createIdentityType("someAgent");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, "someRole"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole(user, someRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole(user, someAnotherRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantRole"));
        identityManager.grantRole(user, someImportantRole);
        query = identityManager.createIdentityQuery(Role.class);
        query.setParameter(Role.ROLE_OF, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someRole"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherRole"));
        Assert.assertTrue((boolean)this.contains(result, "someImportantRole"));
    }

    private boolean contains(List<Role> result, String roleId) {
        for (Role resultRole : result) {
            if (!resultRole.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

