/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.relationship;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.test.idm.AbstractIdentityManagerTestCase;

public class AgentGroupsRelationshipTestCase<T extends Agent>
extends AbstractIdentityManagerTestCase {
    protected T createIdentityType(String name, Partition partition) {
        if (name == null) {
            name = "someAgent";
        }
        return (T)this.createAgent(name, partition);
    }

    protected T createIdentityType(String name) {
        if (name == null) {
            name = "someAgent";
        }
        return (T)this.createAgent(name);
    }

    protected T getIdentityType() {
        return (T)this.getIdentityManager().getAgent("someAgent");
    }

    @Test
    public void testAddAgentToGroup() throws Exception {
        T someAgent = this.createIdentityType("someAgent");
        Group someGroup = this.createGroup("someGroup");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup(someAgent, someGroup);
        Assert.assertTrue((boolean)identityManager.isMember(someAgent, someGroup));
        Group someAnotherGroup = this.createGroup("someAnotherGroup");
        Assert.assertFalse((boolean)identityManager.isMember(someAgent, someAnotherGroup));
        identityManager.addToGroup(someAgent, someAnotherGroup);
        Assert.assertTrue((boolean)identityManager.isMember(someAgent, someAnotherGroup));
    }

    @Test
    public void testRemoveAgentFromGroup() throws Exception {
        T someAgent = this.createIdentityType("someAgent");
        Group someGroup = this.createGroup("someGroup");
        Group someAnotherGroup = this.createGroup("someAnotherGroup");
        IdentityManager identityManager = this.getIdentityManager();
        identityManager.addToGroup(someAgent, someGroup);
        identityManager.addToGroup(someAgent, someAnotherGroup);
        Assert.assertTrue((boolean)identityManager.isMember(someAgent, someGroup));
        Assert.assertTrue((boolean)identityManager.isMember(someAgent, someAnotherGroup));
        identityManager.removeFromGroup(someAgent, someGroup);
        Assert.assertFalse((boolean)identityManager.isMember(someAgent, someGroup));
        identityManager.removeFromGroup(someAgent, someAnotherGroup);
        Assert.assertFalse((boolean)identityManager.isMember(someAgent, someAnotherGroup));
    }

    @Test
    public void testFindAgentGroups() throws Exception {
        Group someGroup = this.createGroup("someGroup");
        Group someAnotherGroup = this.createGroup("someAnotherGroup");
        Group someImportantGroup = this.createGroup("someImportantGroup");
        T user = this.createIdentityType("someAgent");
        IdentityManager identityManager = this.getIdentityManager();
        IdentityQuery query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        List result = query.getResultList();
        Assert.assertFalse((boolean)this.contains(result, "someGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup(user, someGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup(user, someAnotherGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertFalse((boolean)this.contains(result, "someImportantGroup"));
        identityManager.addToGroup(user, someImportantGroup);
        query = identityManager.createIdentityQuery(Group.class);
        query.setParameter(Group.HAS_MEMBER, new Object[]{user});
        result = query.getResultList();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertTrue((boolean)this.contains(result, "someGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someAnotherGroup"));
        Assert.assertTrue((boolean)this.contains(result, "someImportantGroup"));
    }

    private boolean contains(List<Group> result, String roleId) {
        for (Group resultGroup : result) {
            if (!resultGroup.getName().equals(roleId)) continue;
            return true;
        }
        return false;
    }
}

