/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.picketlink.Identity;
import org.picketlink.config.SecurityConfiguration;
import org.picketlink.internal.DefaultIdentity;

public class IdentityBeanDefinition
implements Bean<DefaultIdentity>,
Serializable,
PassivationCapable {
    private static final long serialVersionUID = -4725126763788040967L;
    private final BeanManager beanManager;
    private final InjectionTarget<DefaultIdentity> injectionTarget;
    private SecurityConfiguration securityConfiguration;

    public IdentityBeanDefinition(BeanManager beanManager) {
        this.beanManager = beanManager;
        AnnotatedType annotatedType = this.beanManager.createAnnotatedType(this.getBeanClass());
        this.injectionTarget = this.beanManager.createInjectionTarget(annotatedType);
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public Set<Type> getTypes() {
        HashSet<Type> types = new HashSet<Type>();
        types.add((Type)((Object)Identity.class));
        types.add((Type)((Object)Object.class));
        return types;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
        qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
        return qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        if (this.isStateless()) {
            return RequestScoped.class;
        }
        return SessionScoped.class;
    }

    public String getName() {
        return "identity";
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Class<DefaultIdentity> getBeanClass() {
        return DefaultIdentity.class;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionTarget.getInjectionPoints();
    }

    public DefaultIdentity create(CreationalContext<DefaultIdentity> creationalContext) {
        DefaultIdentity identity = (DefaultIdentity)this.injectionTarget.produce(creationalContext);
        this.injectionTarget.inject((Object)identity, creationalContext);
        this.injectionTarget.postConstruct((Object)identity);
        return identity;
    }

    public void destroy(DefaultIdentity instance, CreationalContext<DefaultIdentity> creationalContext) {
        this.injectionTarget.preDestroy((Object)instance);
        this.injectionTarget.dispose((Object)instance);
        creationalContext.release();
    }

    private boolean isStateless() {
        return this.securityConfiguration != null && this.securityConfiguration.getIdentityBeanConfiguration().isStateless();
    }

    public String getId() {
        return IdentityBeanDefinition.class.getName();
    }
}

