/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.producer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import org.picketlink.IdentityConfigurationEvent;
import org.picketlink.annotations.PicketLink;
import org.picketlink.extension.PicketLinkExtension;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.config.NamedIdentityConfigurationBuilder;
import org.picketlink.idm.config.TokenStoreConfigurationBuilder;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.internal.AuthenticatedAccountContextInitializer;
import org.picketlink.internal.CDIEventBridge;
import org.picketlink.internal.EEJPAContextInitializer;
import org.picketlink.log.BaseLog;

public class IdentityManagementConfiguration {
    private static final String DEFAULT_CONFIGURATION_NAME = "default";
    private static final String JPA_ANNOTATION_PACKAGE = "org.picketlink.idm.jpa.annotations";
    @Inject
    private PicketLinkExtension picketLinkExtension;
    @Inject
    private Instance<IdentityConfiguration> identityConfigInstance;
    @Inject
    @PicketLink
    private Instance<EntityManager> entityManagerInstance;
    @Inject
    private EEJPAContextInitializer entityManagerContextInitializer;
    @Inject
    private AuthenticatedAccountContextInitializer authenticatedAccountContextInitializer;
    @Inject
    private Instance<Token.Consumer<?>> tokenConsumerInstance;
    @Inject
    private Instance<Token.Provider<?>> tokenProviderInstance;
    @Inject
    private CDIEventBridge eventBridge;
    private List<IdentityConfiguration> identityConfiguration;

    List<IdentityConfiguration> getIdentityConfiguration() {
        if (this.identityConfiguration == null) {
            IdentityConfigurationBuilder builder;
            if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("Building identity management configuration.", new Object[0]);
            }
            ArrayList configurations = new ArrayList();
            if (!this.identityConfigInstance.isUnsatisfied()) {
                Iterator iterator = this.identityConfigInstance.iterator();
                while (iterator.hasNext()) {
                    configurations.add(iterator.next());
                }
            }
            if (configurations.isEmpty()) {
                if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                    BaseLog.ROOT_LOGGER.debugf("IdentityConfiguration not provided by the application, creating a default IdentityConfigurationBuilder.", new Object[0]);
                }
                builder = this.picketLinkExtension.getSecurityConfigurationBuilder().idmConfig();
            } else {
                if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                    BaseLog.ROOT_LOGGER.debugf("Found IdentityConfiguration from the environment. Creating a IdentityConfigurationBuilder with them.", new Object[0]);
                }
                builder = new IdentityConfigurationBuilder(configurations);
            }
            this.eventBridge.fireEvent(new IdentityConfigurationEvent(builder));
            if (!builder.isConfigured()) {
                this.configureDefaults(builder);
            }
            this.configureIdentityStores(builder);
            this.identityConfiguration = builder.buildAll();
        }
        return this.identityConfiguration;
    }

    private void configureIdentityStores(IdentityConfigurationBuilder builder) {
        for (NamedIdentityConfigurationBuilder identityConfigurationBuilder : builder.getNamedIdentityConfigurationBuilders()) {
            IdentityStoresConfigurationBuilder stores = identityConfigurationBuilder.stores();
            for (IdentityStoreConfigurationBuilder storeConfigurationBuilder : stores.getIdentityStoresConfigurationBuilder()) {
                storeConfigurationBuilder.addContextInitializer((ContextInitializer)this.authenticatedAccountContextInitializer);
                if (JPAStoreConfigurationBuilder.class.isInstance(storeConfigurationBuilder)) {
                    JPAStoreConfigurationBuilder jpaStoreBuilder = (JPAStoreConfigurationBuilder)storeConfigurationBuilder;
                    if (jpaStoreBuilder.getMappedEntities().isEmpty()) {
                        jpaStoreBuilder.mappedEntity((Class[])this.getEntities());
                    }
                    storeConfigurationBuilder.addContextInitializer((ContextInitializer)this.entityManagerContextInitializer);
                }
                if (!TokenStoreConfigurationBuilder.class.isInstance(storeConfigurationBuilder)) continue;
                TokenStoreConfigurationBuilder tokenStoreBuilder = (TokenStoreConfigurationBuilder)storeConfigurationBuilder;
                if (this.tokenConsumerInstance.isUnsatisfied()) continue;
                tokenStoreBuilder.tokenConsumer(new Token.Consumer[]{(Token.Consumer)this.tokenConsumerInstance.get()});
            }
        }
    }

    private void configureDefaults(IdentityConfigurationBuilder builder) {
        Object[] entities;
        if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
            BaseLog.ROOT_LOGGER.debugf("No configuration provided by the application. Configuring defaults.", new Object[0]);
        }
        if ((entities = this.getEntities()).length == 0) {
            builder.named(DEFAULT_CONFIGURATION_NAME).stores().file().supportAllFeatures();
            if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("Auto configuring File Identity Store. All features are going to be supported.", entities);
            }
        } else {
            builder.named(DEFAULT_CONFIGURATION_NAME).stores().jpa().mappedEntity((Class[])entities).addContextInitializer((ContextInitializer)this.entityManagerContextInitializer).supportAllFeatures();
            if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                BaseLog.ROOT_LOGGER.debugf("Auto configuring JPA Identity Store. All features are going to be supported. Entities [%s]", entities);
            }
        }
    }

    private Class<?>[] getEntities() {
        HashSet<Class> entities = new HashSet<Class>();
        if (!this.entityManagerInstance.isUnsatisfied()) {
            EntityManager entityManager = (EntityManager)this.entityManagerInstance.get();
            for (EntityType entityType : entityManager.getMetamodel().getEntities()) {
                Class javaType = entityType.getJavaType();
                if (Modifier.isAbstract(javaType.getModifiers()) || !this.isIdentityEntity(javaType)) continue;
                if (BaseLog.ROOT_LOGGER.isDebugEnabled()) {
                    BaseLog.ROOT_LOGGER.debugf("PicketLink IDM mapped entity found [%s].", (Object)entityType);
                }
                entities.add(javaType);
            }
        }
        return entities.toArray(new Class[entities.size()]);
    }

    private boolean isIdentityEntity(Class<?> cls) {
        while (!cls.equals(Object.class)) {
            for (Annotation a : cls.getAnnotations()) {
                if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                return true;
            }
            for (Field f : cls.getDeclaredFields()) {
                for (Annotation a : f.getAnnotations()) {
                    if (!a.annotationType().getName().startsWith(JPA_ANNOTATION_PACKAGE)) continue;
                    return true;
                }
            }
            cls = cls.getSuperclass();
        }
        return false;
    }
}

