/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.deployment;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.picketlink.as.subsystem.deployment.PicketLinkAttachments;
import org.picketlink.as.subsystem.deployment.PicketLinkModuleIdentifiers;
import org.picketlink.as.subsystem.federation.service.IdentityProviderService;
import org.picketlink.as.subsystem.federation.service.PicketLinkFederationService;
import org.picketlink.as.subsystem.federation.service.ServiceProviderService;

public class PicketLinkStructureDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final Phase PHASE = Phase.STRUCTURE;
    public static final int PRIORITY = 12288;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        this.markFederationDeployment(phaseContext);
        this.markCoreDeployment(deploymentUnit);
        this.markIDMDeployment(deploymentUnit);
    }

    private void markFederationDeployment(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deployment = phaseContext.getDeploymentUnit();
        ServiceRegistry serviceRegistry = phaseContext.getServiceRegistry();
        ServiceController federationService = serviceRegistry.getService(IdentityProviderService.createServiceName(deployment.getName()));
        if (federationService == null) {
            federationService = serviceRegistry.getService(ServiceProviderService.createServiceName(deployment.getName()));
        }
        if (federationService != null) {
            deployment.putAttachment(PicketLinkAttachments.FEDERATION_ATTACHMENT_KEY, (Object)((PicketLinkFederationService)federationService.getValue()));
        }
    }

    private void markIDMDeployment(DeploymentUnit deployment) {
        this.markDeploymentWithModuleDependency(PicketLinkModuleIdentifiers.ORG_PICKETLINK_IDM_MODULE, PicketLinkAttachments.IDM_ATTACHMENT_KEY, deployment);
    }

    private void markCoreDeployment(DeploymentUnit deployment) {
        this.markDeploymentWithModuleDependency(PicketLinkModuleIdentifiers.ORG_PICKETLINK_CORE_MODULE, PicketLinkAttachments.CORE_ATTACHMENT_KEY, deployment);
    }

    private void markDeploymentWithModuleDependency(ModuleIdentifier moduleIdentifier, AttachmentKey attachment, DeploymentUnit deployment) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deployment.getAttachment(Attachments.MODULE_SPECIFICATION);
        for (ModuleDependency deploymentDependency : moduleSpecification.getUserDependencies()) {
            if (!deploymentDependency.getIdentifier().equals(moduleIdentifier)) continue;
            deployment.putAttachment(attachment, (Object)Boolean.TRUE);
            return;
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    public static boolean isFederationDeployment(DeploymentUnit deployment) {
        return deployment.getAttachment(PicketLinkAttachments.FEDERATION_ATTACHMENT_KEY) != null;
    }

    public static boolean isIDMDeployment(DeploymentUnit deployment) {
        return deployment.getAttachment(PicketLinkAttachments.IDM_ATTACHMENT_KEY) != null;
    }

    public static boolean isCoreDeployment(DeploymentUnit deployment) {
        return deployment.getAttachment(PicketLinkAttachments.CORE_ATTACHMENT_KEY) != null;
    }
}

