/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.config;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.TrustType;
import org.picketlink.identity.federation.core.config.ProviderConfiguration;

public class IDPConfiguration
extends IDPType
implements ProviderConfiguration {
    private String alias;
    private String securityDomain;
    private Map<String, String> trustDomainAlias = new HashMap<String, String>();

    public IDPConfiguration() {
        this.setTrust(new TrustType());
        this.getTrust().setDomains("");
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void addTrustDomain(String domain, String certAlias) {
        if (this.getTrust().getDomains() != null && this.getTrust().getDomains().indexOf(domain) == -1) {
            if (!this.getTrust().getDomains().isEmpty()) {
                this.getTrust().setDomains(this.getTrust().getDomains() + ",");
            }
            this.getTrust().setDomains(this.getTrust().getDomains() + domain);
        }
        if (certAlias != null && !certAlias.trim().isEmpty()) {
            this.getTrustDomainAlias().put(domain, certAlias);
        } else {
            this.getTrustDomainAlias().put(domain, domain);
        }
    }

    public void removeTrustDomain(String domain) {
        if (this.getTrust().getDomains() != null && !this.getTrust().getDomains().isEmpty()) {
            String[] domains;
            this.getTrust().setDomains("");
            for (String currentDomain : domains = this.getTrust().getDomains().split(",")) {
                if (domain.equals(currentDomain) || "".equals(currentDomain.trim())) continue;
                this.getTrust().setDomains(currentDomain + ",");
            }
        } else if (this.getTrust().getDomains() == null) {
            this.getTrust().setDomains("");
        }
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    @Override
    public Map<String, String> getTrustDomainAlias() {
        return this.trustDomainAlias;
    }

    public void setTrustDomainAlias(Map<String, String> trustDomainAlias) {
        this.trustDomainAlias = trustDomainAlias;
    }
}

