/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.parser;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.picketlink.as.subsystem.PicketLinkMessages;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.model.SubsystemDescriber;
import org.picketlink.as.subsystem.model.XMLElement;
import org.picketlink.as.subsystem.parser.ModelWriter;

public abstract class AbstractModelWriter
implements ModelWriter {
    private Map<String, ModelWriter> register;
    private ModelElement modelElement;
    private XMLElement parentElement;

    public AbstractModelWriter(ModelElement modelElement, Map<String, ModelWriter> register) {
        this.modelElement = modelElement;
        this.register = register;
    }

    public AbstractModelWriter(ModelElement trustDomain, XMLElement trust, Map<String, ModelWriter> writers) {
        this(trustDomain, writers);
        this.parentElement = trust;
    }

    public ModelWriter get(String writerKey) {
        ModelWriter writer = this.register.get(writerKey);
        if (writer == null) {
            throw PicketLinkMessages.MESSAGES.noModelElementWriterProvided(writerKey);
        }
        return writer;
    }

    protected List<SimpleAttributeDefinition> getAttributeDefinitions() {
        return SubsystemDescriber.getAttributeDefinition(this.modelElement);
    }

    protected List<ResourceDefinition> getChildResourceDefinitions() {
        return SubsystemDescriber.getChildResourceDefinitions(this.modelElement);
    }

    public void writeAttributes(XMLStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        for (SimpleAttributeDefinition simpleAttributeDefinition : this.getAttributeDefinitions()) {
            if (!modelNode.hasDefined(simpleAttributeDefinition.getXmlName())) continue;
            simpleAttributeDefinition.marshallAsAttribute(modelNode, writer);
        }
    }

    public ModelElement getModelElement() {
        return this.modelElement;
    }

    public XMLElement getParentElement() {
        return this.parentElement;
    }
}

