/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.picketlink.as.subsystem.parser.PicketLinkSubsystemReader_1_0;
import org.picketlink.as.subsystem.parser.PicketLinkSubsystemWriter_1_0;

public enum Namespace {
    PICKETLINK_1_0(1, 0, new PicketLinkSubsystemReader_1_0(), new PicketLinkSubsystemWriter_1_0());

    private static final String BASE_URN = "urn:jboss:domain:picketlink:";
    public static final Namespace CURRENT;
    private static final Map<String, Namespace> namespaces;
    private final int major;
    private final int minor;
    private final XMLElementReader<List<ModelNode>> reader;
    private final XMLElementWriter<SubsystemMarshallingContext> writer;

    private Namespace(int major, int minor, XMLElementReader<List<ModelNode>> reader, XMLElementWriter<SubsystemMarshallingContext> writer) {
        this.major = major;
        this.minor = minor;
        this.reader = reader;
        this.writer = writer;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getUri() {
        return BASE_URN + this.major + "." + this.minor;
    }

    public XMLElementReader<List<ModelNode>> getXMLReader() {
        return this.reader;
    }

    public XMLElementWriter<SubsystemMarshallingContext> getXMLWriter() {
        return this.writer;
    }

    public static Namespace forUri(String uri) {
        return namespaces.get(uri) == null ? null : namespaces.get(uri);
    }

    static {
        CURRENT = PICKETLINK_1_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUri();
            if (name == null) continue;
            map.put(name, namespace);
        }
        namespaces = map;
    }
}

