/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.federation.service;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.picketlink.as.subsystem.federation.service.AbstractEntityProviderService;
import org.picketlink.as.subsystem.model.ModelUtils;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.TrustType;
import org.picketlink.identity.federation.core.config.IDPConfiguration;

public class IdentityProviderService
extends AbstractEntityProviderService<IdentityProviderService, IDPConfiguration> {
    private static final String SERVICE_NAME = "IDPConfigurationService";

    public IdentityProviderService(OperationContext context, ModelNode modelNode) {
        super(context, modelNode);
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        this.getFederationService().setIdentityProviderService(this);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.setConfiguration(new IDPConfiguration());
        this.getFederationService().setIdentityProviderService(null);
    }

    @Override
    protected void doConfigureDeployment(DeploymentUnit deploymentUnit) {
        String domainsStr;
        TrustType trustType;
        if (this.getFederationService().getKeyProvider() != null && (trustType = ((IDPConfiguration)this.getConfiguration()).getTrust()) != null && (domainsStr = trustType.getDomains()) != null) {
            String[] domains = domainsStr.split(",");
            for (int i = 0; i < domains.length; ++i) {
                KeyValueType kv = new KeyValueType();
                kv.setKey(domains[i]);
                String value = domains[i];
                if (((IDPConfiguration)this.getConfiguration()).getTrustDomainAlias() != null) {
                    value = ((IDPConfiguration)this.getConfiguration()).getTrustDomainAlias().get(domains[i]);
                }
                kv.setValue(value);
                this.getFederationService().getKeyProvider().remove(kv);
                this.getFederationService().getKeyProvider().add(kv);
            }
        }
    }

    public static IdentityProviderService getService(ServiceRegistry registry, String name) {
        ServiceController container = registry.getService(IdentityProviderService.createServiceName(name));
        if (container != null) {
            return (IdentityProviderService)container.getValue();
        }
        return null;
    }

    public static ServiceName createServiceName(String alias) {
        return ServiceName.JBOSS.append(new String[]{SERVICE_NAME, alias});
    }

    @Override
    protected IDPConfiguration toProviderType(ModelNode operation) {
        return ModelUtils.toIDPConfig(operation);
    }
}

