/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.model.federation;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.picketlink.as.subsystem.model.ModelUtils;
import org.picketlink.as.subsystem.model.federation.KeyProviderResourceDefinition;
import org.picketlink.as.subsystem.service.FederationService;
import org.picketlink.identity.federation.core.config.KeyProviderType;

public class KeyProviderWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final KeyProviderWriteAttributeHandler INSTANCE = new KeyProviderWriteAttributeHandler();

    private KeyProviderWriteAttributeHandler() {
        super(new AttributeDefinition[]{KeyProviderResourceDefinition.URL, KeyProviderResourceDefinition.SIGN_KEY_ALIAS, KeyProviderResourceDefinition.PASSWD, KeyProviderResourceDefinition.SIGN_KEY_PASSWD});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        KeyProviderType keyProviderType = ModelUtils.toKeyProviderType(model);
        FederationService federationService = FederationService.getService(context.getServiceRegistry(true), operation);
        federationService.setKeyProvider(keyProviderType);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
    }
}

