/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.parser;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.picketlink.as.subsystem.Namespace;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.model.XMLElement;
import org.picketlink.as.subsystem.model.federation.FederationResourceDefinition;
import org.picketlink.as.subsystem.model.federation.KeyProviderResourceDefinition;
import org.picketlink.as.subsystem.model.handlers.HandlerParameterResourceDefinition;
import org.picketlink.as.subsystem.model.handlers.HandlerResourceDefinition;
import org.picketlink.as.subsystem.model.idp.IdentityProviderResourceDefinition;
import org.picketlink.as.subsystem.model.idp.TrustDomainResourceDefinition;
import org.picketlink.as.subsystem.model.saml.SAMLResourceDefinition;
import org.picketlink.as.subsystem.model.sp.ServiceProviderResourceDefinition;

public class PicketLinkSubsystemReader_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        Namespace nameSpace = Namespace.forUri(reader.getNamespaceURI());
        ModelNode subsystemNode = this.createSubsystemRoot();
        list.add(subsystemNode);
        switch (nameSpace) {
            case PICKETLINK_1_0: {
                this.readElement_1_0(reader, list, subsystemNode);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void readElement_1_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentNode) throws XMLStreamException {
        if (Namespace.PICKETLINK_1_0 != Namespace.forUri(reader.getNamespaceURI())) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode federationNode = null;
        ModelNode lastProviderNode = null;
        ModelNode lastHandlerNode = null;
        block10: while (reader.hasNext() && reader.nextTag() != 8) {
            if (!reader.isStartElement() || XMLElement.forName(reader.getLocalName()) != null) continue;
            ModelElement modelKey = ModelElement.forName(reader.getLocalName());
            if (modelKey == null) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (modelKey) {
                case FEDERATION: {
                    federationNode = this.parseFederationConfig(reader, list, parentNode);
                    continue block10;
                }
                case KEY_STORE: {
                    this.parseKeyStoreConfig(reader, list, federationNode);
                    continue block10;
                }
                case IDENTITY_PROVIDER: {
                    lastProviderNode = this.parseIdentityProviderConfig(reader, list, federationNode);
                    continue block10;
                }
                case IDENTITY_PROVIDER_TRUST_DOMAIN: {
                    this.parseTrustDomainConfig(reader, list, lastProviderNode);
                    continue block10;
                }
                case COMMON_HANDLER: {
                    lastHandlerNode = this.parseHandlerConfig(reader, list, lastProviderNode);
                    continue block10;
                }
                case COMMON_HANDLER_PARAMETER: {
                    this.parseHandlerParameterConfig(reader, list, lastHandlerNode);
                    continue block10;
                }
                case SERVICE_PROVIDER: {
                    lastProviderNode = this.parseServiceProviderConfig(reader, list, federationNode);
                    continue block10;
                }
                case SAML: {
                    this.parseSAMLConfig(reader, list, federationNode);
                    continue block10;
                }
            }
            ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKeyStoreConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode federationNode) throws XMLStreamException {
        this.parseConfig(reader, ModelElement.KEY_STORE, KeyProviderResourceDefinition.SIGN_KEY_ALIAS.getName(), list, federationNode, KeyProviderResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseServiceProviderConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode federationNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.SERVICE_PROVIDER, ServiceProviderResourceDefinition.ALIAS.getName(), list, federationNode, ServiceProviderResourceDefinition.INSTANCE.getAttributes());
    }

    private void parseSAMLConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode federationNode) throws XMLStreamException {
        this.parseConfig(reader, ModelElement.SAML, null, list, federationNode, SAMLResourceDefinition.INSTANCE.getAttributes());
    }

    private void parseTrustDomainConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityProviderNode) throws XMLStreamException {
        this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN, TrustDomainResourceDefinition.NAME.getName(), list, identityProviderNode, TrustDomainResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseHandlerConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityProviderNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.COMMON_HANDLER, HandlerResourceDefinition.CLASS.getName(), list, identityProviderNode, HandlerResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseHandlerParameterConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode identityProviderNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.COMMON_HANDLER_PARAMETER, HandlerParameterResourceDefinition.NAME.getName(), list, identityProviderNode, HandlerParameterResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseIdentityProviderConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode federationNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER, IdentityProviderResourceDefinition.ALIAS.getName(), list, federationNode, IdentityProviderResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode parseFederationConfig(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode parentNode) throws XMLStreamException {
        return this.parseConfig(reader, ModelElement.FEDERATION, FederationResourceDefinition.ALIAS.getName(), list, parentNode, FederationResourceDefinition.INSTANCE.getAttributes());
    }

    private ModelNode createSubsystemRoot() {
        ModelNode subsystemAddress = new ModelNode();
        subsystemAddress.add("subsystem", "picketlink");
        subsystemAddress.protect();
        return Util.getEmptyOperation((String)"add", (ModelNode)subsystemAddress);
    }

    private ModelNode parseConfig(XMLExtendedStreamReader reader, ModelElement xmlElement, String key, List<ModelNode> list, ModelNode lastNode, List<SimpleAttributeDefinition> attributes) throws XMLStreamException {
        if (!reader.getLocalName().equals(xmlElement.getName())) {
            return null;
        }
        ModelNode modelNode = Util.getEmptyOperation((String)"add", null);
        for (SimpleAttributeDefinition simpleAttributeDefinition : attributes) {
            simpleAttributeDefinition.parseAndSetParameter(reader.getAttributeValue("", simpleAttributeDefinition.getXmlName()), modelNode, (XMLStreamReader)reader);
        }
        if (key != null) {
            modelNode.get("address").set(lastNode.clone().get("address").add(xmlElement.getName(), modelNode.get(key)));
        } else {
            modelNode.get("address").set(lastNode.clone().get("address").add(xmlElement.getName(), xmlElement.getName()));
        }
        list.add(modelNode);
        return modelNode;
    }
}

