/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.picketlink.identity.federation.core.config.KeyValueType;
import org.picketlink.identity.federation.core.config.PicketLinkType;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.handler.config.Handler;
import org.picketlink.identity.federation.core.parsers.sts.STSConfigParser;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;

public final class PicketLinkConfigUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static STSType createSTSType() {
        STSType stsType = null;
        InputStream stream = null;
        try {
            ClassLoader clazzLoader = PicketLinkConfigUtil.class.getClassLoader();
            URL url = clazzLoader.getResource("core-sts.xml");
            if (url == null) {
                clazzLoader = Thread.currentThread().getContextClassLoader();
                url = clazzLoader.getResource("core-sts");
            }
            stream = url.openStream();
            stsType = (STSType)new STSConfigParser().parse(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return stsType;
    }

    public static void addHandler(Class<? extends SAML2Handler> handlerClassName, PicketLinkType picketLinkType) {
        Handler handler = new Handler();
        handler.setClazz(handlerClassName.getName());
        picketLinkType.getHandlers().add(handler);
    }

    public static void addHandler(Class<? extends SAML2Handler> handlerClassName, Map<String, String> options, PicketLinkType picketLinkType) {
        Handler handler = new Handler();
        handler.setClazz(handlerClassName.getName());
        for (Map.Entry<String, String> option : options.entrySet()) {
            KeyValueType kv = new KeyValueType();
            kv.setKey(option.getKey());
            kv.setValue(option.getValue());
            handler.add(kv);
        }
        picketLinkType.getHandlers().add(handler);
    }
}

