/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.wrappers;

import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.ws.trust.LifetimeType;
import org.picketlink.identity.federation.ws.wss.utility.AttributedDateTime;

public class Lifetime {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final LifetimeType delegate;
    private XMLGregorianCalendar created;
    private XMLGregorianCalendar expires;
    private DatatypeFactory factory;

    public Lifetime(GregorianCalendar created, GregorianCalendar expires) {
        try {
            this.factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dce) {
            throw logger.wsTrustUnableToGetDataTypeFactory(dce);
        }
        this.created = this.factory.newXMLGregorianCalendar(created).normalize();
        this.expires = this.factory.newXMLGregorianCalendar(expires).normalize();
        this.delegate = new LifetimeType();
        AttributedDateTime dateTime = new AttributedDateTime();
        dateTime.setValue(this.created.toXMLFormat());
        this.delegate.setCreated(dateTime);
        dateTime = new AttributedDateTime();
        dateTime.setValue(this.expires.toXMLFormat());
        this.delegate.setExpires(dateTime);
    }

    public Lifetime(LifetimeType lifetime) {
        if (lifetime == null) {
            throw logger.nullArgumentError("LifetimeType");
        }
        try {
            this.factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dce) {
            throw logger.wsTrustUnableToGetDataTypeFactory(dce);
        }
        this.delegate = lifetime;
        this.created = this.factory.newXMLGregorianCalendar(lifetime.getCreated().getValue());
        this.expires = this.factory.newXMLGregorianCalendar(lifetime.getExpires().getValue());
        if (this.created.getTimezone() != 0) {
            this.created = this.created.normalize();
            this.delegate.getCreated().setValue(this.created.toXMLFormat());
        }
        if (this.expires.getTimezone() != 0) {
            this.expires = this.expires.normalize();
            this.delegate.getExpires().setValue(this.expires.toXMLFormat());
        }
    }

    public XMLGregorianCalendar getCreated() {
        return this.created;
    }

    public void setCreated(XMLGregorianCalendar created) {
        this.created = created.normalize();
        this.delegate.getCreated().setValue(this.created.toXMLFormat());
    }

    public GregorianCalendar getCreatedCalendar() {
        return this.created.toGregorianCalendar();
    }

    public void setCreatedCalendar(GregorianCalendar created) {
        this.setCreated(this.factory.newXMLGregorianCalendar(created));
    }

    public XMLGregorianCalendar getExpires() {
        return this.expires;
    }

    public void setExpires(XMLGregorianCalendar expires) {
        this.expires = expires.normalize();
        this.delegate.getExpires().setValue(this.expires.toXMLFormat());
    }

    public GregorianCalendar getExpiresCalendar() {
        return this.expires.toGregorianCalendar();
    }

    public void setExpiresCalendar(GregorianCalendar expires) {
        this.setExpires(this.factory.newXMLGregorianCalendar(expires));
    }

    public LifetimeType getDelegate() {
        return this.delegate;
    }
}

