/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.model;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.picketlink.as.subsystem.PicketLinkExtension;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.model.SubsystemDescriber;

public abstract class AbstractResourceDefinition
extends SimpleResourceDefinition {
    private ModelElement modelElement;
    private List<SimpleAttributeDefinition> attributes = new ArrayList<SimpleAttributeDefinition>();

    protected AbstractResourceDefinition(ModelElement modelElement, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(PathElement.pathElement((String)modelElement.getName()), PicketLinkExtension.getResourceDescriptionResolver(modelElement.getName()), addHandler, removeHandler);
        this.modelElement = modelElement;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (SimpleAttributeDefinition attribute : this.getAttributes()) {
            this.addAttributeDefinition(attribute, null, this.doGetAttributeWriterHandler(), resourceRegistration);
        }
        this.registerResourceOperation(resourceRegistration);
    }

    protected void registerResourceOperation(ManagementResourceRegistration resourceRegistration) {
    }

    protected abstract OperationStepHandler doGetAttributeWriterHandler();

    public List<SimpleAttributeDefinition> getAttributes() {
        return this.attributes;
    }

    protected void addAttribute(SimpleAttributeDefinition attribute) {
        this.attributes.add(attribute);
    }

    protected void addAttributeDefinition(SimpleAttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler, ManagementResourceRegistration resourceRegistration) {
        SubsystemDescriber.addAttributeDefinition(this.modelElement, definition);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)definition, readHandler, writeHandler);
    }

    protected void addChildResourceDefinition(ResourceDefinition definition, ManagementResourceRegistration resourceRegistration) {
        SubsystemDescriber.addChildResourceDefinition(this.modelElement, definition);
        resourceRegistration.registerSubModel(definition);
    }
}

