/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.model;

import java.util.HashMap;
import java.util.Map;

public enum ModelElement {
    COMMON_ALIAS("alias"),
    COMMON_URL("url"),
    COMMON_NAME("name"),
    COMMON_SECURITY_DOMAIN("security-domain"),
    COMMON_VALUE("value"),
    COMMON_STRICT_POST_BINDING("strict-post-binding"),
    COMMON_SUPPORTS_SIGNATURES("supportsSignatures"),
    COMMON_HANDLER("handler"),
    COMMON_HANDLER_CLASS("class"),
    COMMON_HANDLER_PARAMETER("handler-parameter"),
    FEDERATION("federation"),
    IDENTITY_PROVIDER("identity-provider"),
    IDENTITY_PROVIDER_TRUST_DOMAIN("trust-domain"),
    IDENTITY_PROVIDER_TRUST_DOMAIN_NAME("name"),
    IDENTITY_PROVIDER_TRUST_DOMAIN_CERT_ALIAS("cert-alias"),
    IDENTITY_PROVIDER_SAML_METADATA("idp-metadata"),
    IDENTITY_PROVIDER_SAML_METADATA_WANT_AUTHN_REQUESTS_SIGNED("wantAuthnRequestsSigned"),
    IDENTITY_PROVIDER_SAML_METADATA_ORGANIZATION("organization"),
    IDENTITY_PROVIDER_EXTERNAL("external"),
    IDENTITY_PROVIDER_ATTRIBUTE_MANAGER("attribute-manager"),
    IDENTITY_PROVIDER_ROLE_GENERATOR("role-generator"),
    IDENTITY_PROVIDER_ENCRYPT("encrypt"),
    KEY_STORE("key-store"),
    KEY_STORE_PASSWD("passwd"),
    KEY_STORE_SIGN_KEY_ALIAS("sign-key-alias"),
    KEY_STORE_SIGN_KEY_PASSWD("sign-key-passwd"),
    SERVICE_PROVIDER("service-provider"),
    SERVICE_PROVIDER_POST_BINDING("post-binding"),
    SERVICE_PROVIDER_ERROR_PAGE("error-page"),
    SERVICE_PROVIDER_LOGOUT_PAGE("logout-page"),
    SECURITY_TOKEN_SERVICE("security-token-service"),
    SAML("saml"),
    SAML_TOKEN_TIMEOUT("token-timeout"),
    SAML_CLOCK_SKEW("clock-skew"),
    METRICS_CREATED_ASSERTIONS_COUNT("created-assertions-count"),
    METRICS_RESPONSE_TO_SP_COUNT("response-to-sp-count"),
    METRICS_ERROR_RESPONSE_TO_SP_COUNT("error-response-to-sp-count"),
    METRICS_ERROR_SIGN_VALIDATION_COUNT("error-sign-validation-count"),
    METRICS_ERROR_TRUSTED_DOMAIN_COUNT("error-trusted-domain-count"),
    METRICS_EXPIRED_ASSERTIONS_COUNT("expired-assertions-count"),
    METRICS_LOGIN_INIT_COUNT("login-init-count"),
    METRICS_LOGIN_COMPLETE_COUNT("login-complete-count"),
    METRICS_REQUEST_FROM_IDP_COUNT("request-from-idp-count"),
    METRICS_RESPONSE_FROM_IDP_COUNT("response-from-idp-count"),
    METRICS_REQUEST_TO_IDP_COUNT("request-to-idp-count");

    private static final Map<String, ModelElement> modelElements;
    private String name;

    private ModelElement(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static ModelElement forName(String name) {
        return modelElements.get(name);
    }

    static {
        modelElements = new HashMap<String, ModelElement>();
        for (ModelElement element : ModelElement.values()) {
            modelElements.put(element.getName(), element);
        }
    }
}

